% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_simulation.R
\name{batch_simulation}
\alias{batch_simulation}
\alias{print.batch_simulation}
\title{Perform a batch simulation.}
\usage{
batch_simulation(arg_grid, sim_fun, default_list, bigmemory = TRUE, ...)

\method{print}{batch_simulation}(x, detail = FALSE, ...)
}
\arguments{
\item{arg_grid}{An \code{arg_grid} object. See \code{\link[=make_arg_grid]{make_arg_grid()}}.}

\item{sim_fun}{The simulation function. See \code{\link[=sim_fun_test]{sim_fun_test()}}
for an example.}

\item{default_list}{A list of default values for \code{sim_fun}.}

\item{bigmemory}{Use \code{\link[=hash_big_matrix-class]{hash_big_matrix-class()}} to store large matrices?}

\item{...}{Other parameters passed to \code{sim_fun}}

\item{x}{An \code{arg_set} object}

\item{detail}{Do you want to print the object details as a full list?}
}
\value{
A \code{batch_simulation} object, also a data frame.
The first column, \code{var}, is a list of
\code{ele_list} that contains all the variables; the second to the second
last columns are the values of the variables; the last column is the
output of the simulation function.
}
\description{
Perform a batch simulation.
}
\section{Functions}{
\itemize{
\item \code{batch_simulation()}: Perform a batch simulation.

}}
\examples{
batch_arg_set_grad <- new_arg_set()
batch_arg_set_grad <- batch_arg_set_grad \%>\%
  add_arg_ele(
    arg_name = "parameter", ele_name = "a",
    start = -6, end = -1, by = 1
  )
batch_grid_grad <- make_arg_grid(batch_arg_set_grad)
batch_output_grad <- batch_simulation(batch_grid_grad, sim_fun_grad,
  default_list = list(
    initial = list(x = 0, y = 0),
    parameter = list(a = -4, b = 0, c = 0, sigmasq = 1)
  ),
  length = 1e2,
  seed = 1614,
  bigmemory = FALSE
)
print(batch_output_grad)
}
