% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotdeck.R, R/linearmodels.R, R/treemodels.R
\name{impute_rhd}
\alias{impute_}
\alias{impute_cart}
\alias{impute_const}
\alias{impute_knn}
\alias{impute_lm}
\alias{impute_median}
\alias{impute_pmm}
\alias{impute_proxy}
\alias{impute_rf}
\alias{impute_rhd}
\alias{impute_rlm}
\alias{impute_shd}
\title{Impute missing data}
\usage{
impute_rhd(dat, formula, pool = c("complete", "univariate", "multivariate"),
  prob, ...)

impute_shd(dat, formula, pool = c("complete", "univariate", "multivariate"),
  order = c("locf", "nocb"), ...)

impute_pmm(dat, formula, predictor = impute_lm, pool = c("complete",
  "univariate", "multivariate"), ...)

impute_knn(dat, formula, pool = c("complete", "univariate", "multivariate"),
  k = 5, ...)

impute_lm(dat, formula, add_residual = c("none", "observed", "normal"), ...)

impute_rlm(dat, formula, add_residual = c("none", "observed", "normal"), ...)

impute_const(dat, formula, add_residual = c("none", "observed", "normal"),
  ...)

impute_median(dat, formula, add_residual = c("none", "observed", "normal"),
  ...)

impute_proxy(dat, formula, add_residual = c("none", "observed", "normal"),
  ...)

impute_cart(dat, formula, add_residual = c("none", "observed", "normal"), cp,
  ...)

impute_rf(dat, formula, add_residual = c("none", "observed", "normal"), ...)
}
\arguments{
\item{dat}{\code{[data.frame]}, with variables to be imputed and their
predictors.}

\item{formula}{\code{[formula]} imputation model description (see Details below).}

\item{pool}{Specify donor pool. See under 'Hot deck imputation'.}

\item{prob}{\code{[numeric]} Sampling probability weights (passed through to
\code{\link[base]{sample}}). Must be of length \code{nrow(dat)}.}

\item{...}{further arguments passed to 
\itemize{
\item{\code{\link[stats]{lm}} for \code{impute_lm}}
\item{\code{\link[MASS]{rlm}} for \code{impute_rlm}}
\item{\code{\link[base]{order}} for \code{impute_shd}} 
\item{The \code{predictor} for \code{impute_pmm}}
\item{\code{\link[randomForest]{randomForest}} for \code{impute_rf}}
}}

\item{order}{Last Observation Carried Forward or Next Observarion Carried Backward}

\item{predictor}{\code{[function]} Imputation to use for predictive part in
predictive mean matching. Any of the \code{impute_} functions of this
package (it makes no sense to use a hot-deck imputation).}

\item{k}{Number of nearest neighbours to draw the donor from.}

\item{add_residual}{\code{[character]} Type of residual to add. \code{"normal"} 
means that the imputed value is drawn from \code{N(mu,sd)} where \code{mu}
and \code{sd} are estimated from the model's residuals (\code{mu} should equal
zero in most cases). If \code{add_residual = "observed"}, residuals are drawn
(with replacement) from the model's residuals. Ignored for non-numeric 
predicted variables.}

\item{cp}{The complexity parameter used to \code{\link[rpart]{prune}} the CART model. If
omitted, no pruning takes place. If a single number, the same complexity parameter is
used for each imputed variable. If of length \code{#} of variables imputed, the complexity
parameters used must be in the same order as the predicted variables in the \code{model}
formula.}
}
\value{
\code{dat}, but imputed where possible.
}
\description{
Use to fit and impute missing data.
}
\section{Hot deck imputation}{



\itemize{
\item{\code{impute_rhd} The predictor variables in the \code{model} argument are used to split the data 
set into groups prior to imputation (use \code{~ 1} to specify that no grouping is applied).}
\item{\code{impute_shd} The predictor variables are used to sort the data.}
\item{\code{impute_knn} The predictors are used to determine Gower's distance 
 between records (see \code{\link[gower]{gower_topn}})}.
} 

The \code{pool} argument is used to specify the donor pool as follows.
\itemize{
\item{\code{"complete"}. Only records for which the variables on the
   left-hand-side of the model formula are complete are used as donors. If a
   record has multiple missings, all imputations are taken from a single 
   donor.}
\item{\code{"univariate"}. Imputed variables are treated one by one and
   independently so the order of variable imputation is unimportant. If a 
   record has multiple missings, separate donors are drawn for each missing 
   value.}
\item{\code{"multivariate"}. A donor pool is created for each missing data 
   pattern. If a record has multiple missings, all imputations are taken from 
   a single donor.}
}
}

\section{Specifying the imputation model}{


Formulas are of the form

\code{IMPUTED_VARIABLES ~ MODEL_SPECIFICATION [ | GROUPING_VARIABLES ] }

The left-hand-side of the formula object lists the variable or variables to 
be imputed. The interpretation of the independent variables on the
right-hand-side depends on the underlying imputation model. If grouping
variables are specified, the data set is split according to the values of
those variables, and model estimation and imputation occur independently for
each group.


Grouping using \code{dplyr::group_by} is also supported. If groups are 
defined in both the formula and using \code{dplyr::group_by}, the data is 
grouped by the union of grouping variables. Any missing value in one of the
grouping variables results in an error.

Grouping is ignored for \code{impute_const}.
}

\section{Details}{


The functions are designed to be robust against failing imputations. This means that
rather than emitting an error, functions show the following behaviour.

\itemize{
\item{If a value cannot be imputed because one of its predictors is missing, the value will
remain missing after imputation.}

\item{If a model cannot be fitted, e.g. because the imputed model is missing, a warning
is emitted and for that variable no imputation will take place.}
}
}

\section{Model descriptions}{


\tabular{ll}{
\bold{Model} \tab \bold{description}\cr
\code{impute_lm} \tab Use \code{stats::lm} to train the imputation model.\cr
\code{impute_rlm} \tab Use \code{MASS::rlm} to train the imputation model.\cr
\code{impute_median} \tab Median imputation. Predictors are treated
   as grouping variables for computing medians.\cr
\code{impute_const} \tab Impute a constant value \cr
\code{impute_proxy} \tab Copy a value from the predictor variable.\cr
\code{impute_rhd} \tab Random hot deck. Predictors are used to group the donors.\cr
\code{impute_shd} \tab Sequential hot deck. Predictors sort the data.\cr
\code{impute_knn} \tab k-nearest neighbour imputation. Predictors are used to determine Gower's distance.\cr
\code{impute_pmm} \tab Predictive mean matching. \cr
\code{impute_cart} \tab Use \code{rpart::rpart} to train a CART model.\cr
\code{impute_rf} \tab Use \code{randomForest::randomForest} to train the predictive model.
}
}
\examples{

data(iris)
irisNA <- iris
irisNA[1:4, "Sepal.Length"] <- NA
irisNA[3:7, "Sepal.Width"] <- NA

# impute a single variable (Sepal.Length)
i1 <- impute_lm(irisNA, Sepal.Length ~ Sepal.Width + Species)

# impute both Sepal.Length and Sepal.Width, using robust linear regression
i2 <- impute_rlm(irisNA, Sepal.Length + Sepal.Width ~ Species + Petal.Length)

}
\seealso{
\href{../doc/intro.html}{Getting started with simputation}, 
\code{\link[stats]{lm}} \code{\link[MASS]{rlm}} \code{\link[rpart]{rpart}}
}

