% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_data.R
\name{addPeriods}
\alias{addPeriods}
\title{Create longitudinal/panel data}
\usage{
addPeriods(
  dtName,
  nPeriods = NULL,
  idvars = "id",
  timevars = NULL,
  timevarName = "timevar",
  timeid = "timeID",
  perName = "period",
  periodVec = NULL
)
}
\arguments{
\item{dtName}{Name of existing data table}

\item{nPeriods}{Number of time periods for each record}

\item{idvars}{Names of index variables (in a string vector) that will be
repeated during each time period}

\item{timevars}{Names of time dependent variables. Defaults to NULL.}

\item{timevarName}{Name of new time dependent variable}

\item{timeid}{Variable name for new index field. Defaults to "timevar"}

\item{perName}{Variable name for period field. Defaults to "period"}

\item{periodVec}{Vector of period times. Defaults to NULL}
}
\value{
An updated data.table that that has multiple rows
per observation in dtName
}
\description{
Create longitudinal/panel data
}
\details{
It is possible to generate longitudinal data with varying 
numbers of measurement periods as well as varying time intervals between 
each measurement period. This is done by defining specific variables \emph{in} the 
data set that define the number of observations per subject and the average 
interval time between each observation. \bold{\emph{nCount}} defines the number of 
measurements for an individual; \bold{\emph{mInterval}} specifies the average time between 
intervals for a subject; and \bold{\emph{vInterval}} specifies the variance of those 
interval times. If \bold{\emph{mInterval}} is not defined, no intervals are used. If \bold{\emph{vInterval}} is set to 0 or is not defined, the interval for
a subject is determined entirely by the mean interval. If \bold{\emph{vInterval}} is 
greater than 0, time intervals are generated using a gamma distribution 
with specified mean and dispersion. If either \bold{\emph{nPeriods}} or \bold{\emph{timevars}} 
is specified, that will override any \bold{\emph{nCount}}, \bold{\emph{mInterval}}, and 
\bold{\emph{vInterval}} data.

\bold{\emph{periodVec}} is used to specify measurement periods that are different
the default counting variables. If \bold{\emph{periodVec}} is not specified, 
the periods default to \emph{0, 1, ... n-1}, with \emph{n} periods. If 
\bold{\emph{periodVec}} is specified as \emph{c(x_1, x_2, ... x_n)}, then
\emph{x_1, x_2, ... x_n} represent the measurement periods.
}
\examples{
tdef <- defData(varname = "T", dist = "binary", formula = 0.5)
tdef <- defData(tdef, varname = "Y0", dist = "normal", formula = 10, variance = 1)
tdef <- defData(tdef, varname = "Y1", dist = "normal", formula = "Y0 + 5 + 5 * T", variance = 1)
tdef <- defData(tdef, varname = "Y2", dist = "normal", formula = "Y0 + 10 + 5 * T", variance = 1)

dtTrial <- genData(5, tdef)
dtTrial

dtTime <- addPeriods(dtTrial,
  nPeriods = 3, idvars = "id",
  timevars = c("Y0", "Y1", "Y2"), timevarName = "Y"
)
dtTime

# Varying # of periods and intervals - need to have variables
# called nCount and mInterval

def <- defData(varname = "xbase", dist = "normal", formula = 20, variance = 3)
def <- defData(def, varname = "nCount", dist = "noZeroPoisson", formula = 6)
def <- defData(def, varname = "mInterval", dist = "gamma", formula = 30, variance = .01)
def <- defData(def, varname = "vInterval", dist = "nonrandom", formula = .07)

dt <- genData(200, def)
dt[id \%in\% c(8, 121)]

dtPeriod <- addPeriods(dt)
dtPeriod[id \%in\% c(8, 121)] # View individuals 8 and 121 only
}
\concept{group_data}
