% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_freqs.R
\name{allele_freqs}
\alias{allele_freqs}
\title{Compute locus allele frequencies}
\usage{
allele_freqs(X, loci_on_cols = FALSE, fold = FALSE, m_chunk_max = 1000)
}
\arguments{
\item{X}{The genotype matrix (regular R matrix or BEDMatrix object).
Missing values are ignored in averages.}

\item{loci_on_cols}{If \code{TRUE}, \code{X} has loci on columns and individuals on rows; if false (the default), loci are on rows and individuals on columns.
If \code{X} is a BEDMatrix object, code assumes loci on columns (\code{loci_on_cols} is ignored).}

\item{fold}{If \code{TRUE}, allele frequencies are converted to minor allele frequencies.
Default is to return frequencies for the given allele counts in \code{X} (regardless of whether it is the minor or major allele).}

\item{m_chunk_max}{BEDMatrix-specific, sets the maximum number of loci to process at the time.
If memory usage is excessive, set to a lower value than default (expected only for extremely large numbers of individuals).}
}
\value{
The vector of allele frequencies, one per locus.
Names are set to the locus names, if present.
}
\description{
On a regular matrix, this is essentially a wrapper for \code{\link[=colMeans]{colMeans()}} or \code{\link[=rowMeans]{rowMeans()}} depending on \code{loci_on_cols}.
On a BEDMatrix object, the locus allele frequencies are computed keeping memory usage low.
}
\examples{
# Construct toy data
X <- matrix(
    c(0, 1, 2,
      1, 0, 1,
      1, NA, 2),
    nrow = 3,
    byrow = TRUE
)

# row means
allele_freqs(X)
c(1/2, 1/3, 3/4)

# row means, in minor allele frequencies
allele_freqs(X, fold = TRUE)
c(1/2, 1/3, 1/4)

# col means
allele_freqs(X, loci_on_cols = TRUE)
c(1/3, 1/4, 5/6)

}
