% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_ma1}
\alias{gen_ma1}
\title{Generate an Moving Average Order 1 (MA(1)) Process}
\usage{
gen_ma1(N, theta = 0.3, sigma2 = 1)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{theta}{A \code{double} that contains moving average.}

\item{sigma2}{A \code{double} that contains process variance.}
}
\value{
A \code{vec} containing the MA(1) process.
}
\description{
Generate an MA(1) Process given \eqn{\theta} and \eqn{\sigma^2}.
}
\details{
The function implements a way to generate the \eqn{x_t}{x[t]} values without calling the general ARMA function.
}
\section{Process Definition}{

The Moving Average order 1 (MA(1)) process with non-zero parameter \eqn{\theta \in (-1,+1)}{theta in (-1,+1)} 
and \eqn{\sigma^2 \in {\rm I\!R}^{+}}{sigma^2 in R^{+}}. This process is defined as:
\deqn{{x_t} = {\varepsilon_t} + {\theta _1}{\varepsilon_{t - 1}}}{x[t] = W[t] + theta*W[t-1]},
 where 
 \deqn{{\varepsilon_t}\mathop  \sim \limits^{iid} N\left( {0,\sigma^2} \right)}{W[t] ~ N(0,sigma^2) iid}
}

\section{Generation Algorithm}{

The function first generates a vector of white noise using \code{\link{gen_wn}} and then obtains the
MA values under the above equation. 

The \eqn{X_0}{X[0]} (first value of \eqn{X_t}{X[t]}) is discarded.
}

\keyword{internal}
