% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourPlot2.R
\name{contourPlot2}
\alias{contourPlot2}
\title{New contour plot of pollutant concentration}
\usage{
contourPlot2(
  data,
  x = "x",
  y = "y",
  z = "z",
  domain = NULL,
  background = NULL,
  underlayer = NULL,
  overlayer = NULL,
  legend = NULL,
  levels = NULL,
  size = 0,
  fill = TRUE,
  tile = FALSE,
  transparency = 0.75,
  colors = NULL,
  bare = FALSE
)
}
\arguments{
\item{data}{A dataframe containing data to be plotted.}

\item{x}{(string) Name of the column with Easting data.}

\item{y}{(string) Name of the column with Northing data.}

\item{z}{(string) Name of the column with values data.}

\item{domain}{An array with min X, max X, min Y, max Y, number of ticks on X
axis, number of ticks on Y axis (optional).}

\item{background}{String containing the path to the png file to be plotted as
a basemap (optional).}

\item{underlayer}{Array of strings containing layers to be plotted between
basemap and contour plot (optional).}

\item{overlayer}{Array of strings containing layers to be plotted on top of
the contour plot (optional).}

\item{legend}{(string) Legend title (optional).}

\item{levels}{Array of levels for contour plot. If not set, automatic levels
are plotted.}

\item{size}{float with the thickness of the contour line.}

\item{fill}{boolean (default TRUE) to specify whether the contour plot
should be filled or not.}

\item{tile}{boolean (default FALSE) to do tiles instead of contour}

\item{transparency}{float (between 0 and 1, default=0.66). Transparency level
of the contour plot.}

\item{colors}{Colour palette for contour plot}

\item{bare}{Boolean (default FALSE) parameter to completely remove axis,
legend, titles and any other graphical element from the plot.}
}
\value{
A \code{ggplot2} plot.
}
\description{
\code{contourPlot} plots a contour map of pollutants.
}
\details{
This is a convenience function to plot contour levels of a pollutant matrix
with \code{ggplot2} version >= 3.3.0.

Domain data are expected to be on a regular rectangular grid with
UTM coordinates.

Since version 2.4.0, when \code{tile = TRUE} the intervals include the lowest
value and exclude the highest value: [min, max).
In previous version it was the opposite.
}
\examples{
# Load example data in long format
data(volcano)
volcano3d <- reshape2::melt(volcano)
names(volcano3d) <- c("x", "y", "z")
# Contour plot with default options
contourPlot2(volcano3d)

# Set levels, and properly format the legend title:
contourPlot2(volcano3d, 
             levels = c(-Inf, seq(100, 200, 20), Inf),
             legend = expression(PM[10]~"["~mu*g~m^-3~"]"))

# Sometimes, instead of a contour plot it is better to plot the original
# raster data, without any interpolation:
contourPlot2(volcano3d, 
             levels = c(-Inf, seq(100, 200, 20), Inf), 
             tile = TRUE)

# Since contourPlot2 returns a `ggplot2` object, you can add instructions as:
library(ggplot2)
contourPlot2(volcano3d) +
    ggtitle("Example volcano data") +
    labs(x = NULL, y = NULL)

}
