% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{do_in_parallel}
\alias{do_in_parallel}
\title{Do a function in parallel.}
\usage{
do_in_parallel(function_to_do, function_params, save_to_file, save_params,
  socket_names, libraries, save_locally = TRUE)
}
\arguments{
\item{function_to_do}{this is the function that will be done in parallel}

\item{function_params}{a list where \code{function_params[[i]]} is
a named list of parameters to be passed to \code{function_to_do} for
job \code{i}}

\item{save_to_file}{function that saves stuff to file}

\item{save_params}{a list where \code{save_params[[i]]}
is a named list of parameters to be passed to \code{save_to_file} for
job \code{i}. Each \code{save_params[[i]]} must include \code{out_dir},
which is location where file is to be saved.}

\item{socket_names}{quoting from \code{\link[parallel]{makePSOCKcluster}}:
"either a character vector of host names on which to run the worker
copies of R, or a positive integer (in which case that number of
copies is run on localhost)."}

\item{libraries}{character vector of R packages that will be needed on the
slaves.}

\item{save_locally}{if TRUE, then files will be saved on slaves.  If FALSE,
they will be saved on master.}
}
\description{
This is an internal function. The function_to_do is done in parallel
and its output is saved either on slave (locally) or on master.
}
\keyword{internal}

