% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{haystack}
\alias{haystack}
\alias{haystack.matrix}
\alias{haystack.data.frame}
\alias{haystack.Seurat}
\alias{haystack.SingleCellExperiment}
\title{The main Haystack function}
\usage{
haystack(x, ...)

\method{haystack}{matrix}(
  x,
  dim1 = 1,
  dim2 = 2,
  detection,
  method = "highD",
  use.advanced.sampling = NULL,
  dir.randomization = NULL,
  scale = TRUE,
  grid.points = 100,
  grid.method = "centroid",
  ...
)

\method{haystack}{data.frame}(
  x,
  dim1 = 1,
  dim2 = 2,
  detection,
  method = "highD",
  use.advanced.sampling = NULL,
  dir.randomization = NULL,
  scale = TRUE,
  grid.points = 100,
  grid.method = "centroid",
  ...
)

\method{haystack}{Seurat}(
  x,
  assay = "RNA",
  slot = "data",
  coord = "pca",
  dims = NULL,
  cutoff = 1,
  method = NULL,
  use.advanced.sampling = NULL,
  ...
)

\method{haystack}{SingleCellExperiment}(
  x,
  assay = "counts",
  coord = "TSNE",
  dims = NULL,
  cutoff = 1,
  method = NULL,
  use.advanced.sampling = NULL,
  ...
)
}
\arguments{
\item{x}{a matrix or other object from which coordinates of cells can be extracted.}

\item{...}{further parameters passed down to methods.}

\item{dim1}{column index or name of matrix for x-axis coordinates.}

\item{dim2}{column index or name of matrix for y-axis coordinates.}

\item{detection}{A logical matrix showing which genes (rows) are detected in which cells (columns)}

\item{method}{choose between highD (default) and 2D haystack.}

\item{use.advanced.sampling}{If NULL naive sampling is used. If a vector is given (of length = no. of cells) sampling is done according to the values in the vector.}

\item{dir.randomization}{If NULL, no output is made about the random sampling step. If not NULL, files related to the randomizations are printed to this directory.}

\item{scale}{Logical (default=TRUE) indicating whether input coordinates in x should be scaled to mean 0 and standard deviation 1.}

\item{grid.points}{An integer specifying the number of centers (gridpoints) to be used for estimating the density distributions of cells. Default is set to 100.}

\item{grid.method}{The method to decide grid points for estimating the density in the high-dimensional space. Should be "centroid" (default) or "seeding".}

\item{assay}{name of assay data for Seurat method.}

\item{slot}{name of slot for assay data for Seurat method.}

\item{coord}{name of coordinates slot for specific methods.}

\item{dims}{dimensions from coord to use. By default, all.}

\item{cutoff}{cutoff for detection.}
}
\value{
An object of class "haystack"
}
\description{
The main Haystack function
}
