
#################################################################
# categorize variables into classes
categorize <- function( dat , categorical=NULL , quant=NULL ,
			lowest=0){

	dat2 <- dat

	#*********************
	# categorize variables, numbered from lowest to max
	dfr <- NULL
	if (! is.null( categorical) ){
		VV <- base::length(categorical)	
		for (vv in 1:VV){
			# vv <- 1
			var.vv <- categorical[vv]    
			dat.vv <- dat[,var.vv]
			vals.vv <- base::sort( base::unique( dat.vv ) )
			dfr.vv <- base::data.frame( "index" = vv , "variable" = var.vv ,
					"column" = base::which( colnames(dat) == var.vv ) ,
					"orig" = vals.vv , 
					"recode" = base::seq( lowest , base::length(vals.vv) -1 + lowest)
								)      
			dfr <- base::rbind( dfr, dfr.vv )
			dat2[ , var.vv] <- base::match( dat[,var.vv] , vals.vv ) - 1 + lowest
		}
	}
	#**************************
	# categorize continuous variables into quantiles
	
	dfr2 <- NULL
	
	if ( ! is.null(quant) ){
		vars <- names(quant)
		VV <- base::length(vars)
	
		for (vv in 1:VV){
			# vv <- 1
			vars.vv <- vars[vv]
			q1 <- quant[ vars.vv ]
			quant.vv <- stats::quantile( dat[,vars.vv] , na.rm=TRUE , 
						   prob = seq( 0 , 1 , len=q1+1 )  )
			quant.vv[1] <- quant.vv[1] - 1
			quant.vv[q1+1] <- quant.vv[q1+1] + 1		
			quant.vv <- base::unique( quant.vv )
			m1 <- base::cut( dat[,vars.vv]  , breaks = quant.vv )
			m2 <- base::sort( base::unique(m1) )
			dfr2.vv <- base::data.frame( "index" = vv , "variable" = vars.vv ,
						"column" = base::which( colnames(dat) == vars.vv ) ,
						"orig" = m2 , 
						"min" = quant.vv[ - base::length(quant.vv) ] ,
						"max" = quant.vv[ - 1 ] ,						
						"recode" = base::seq( 0 , base::length(m2) -1 + lowest)
									)  				
			# The minimum is not included in the interval
			# while the maximum value is included in the interval.
			dfr2 <- base::rbind( dfr2 , dfr2.vv )							
			dat2[ , vars.vv ] <- base::match( m1 , m2 ) - 1 + lowest		
		}
	}
						
	#***************************
	# OUTPUT
	res <- base::list( "data" = dat2 , "categ_design" = dfr ,
			"quant_design" = dfr2 )
	base::return(res)	
}
#################################################################			
