% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\name{sirus.cv}
\alias{sirus.cv}
\title{Estimation of p0.}
\usage{
sirus.cv(data, y, type = "auto", nfold = 10, ncv = NULL,
  num.rule.max = 25, q = 10, num.trees.step = 1000, alpha = 0.05,
  mtry = NULL, max.depth = 2, num.trees = NULL, num.threads = NULL,
  replace = TRUE, sample.fraction = NULL, verbose = TRUE,
  seed = NULL)
}
\arguments{
\item{data}{Input dataframe, each row is an observation vector.}

\item{y}{Numeric response variable. For classification, y takes only 0 and 1 values.}

\item{type}{'reg' for regression, 'classif' for classification and 'auto' for automatic detection (classification if y takes only 0 and 1 values).}

\item{nfold}{Number of folds in the cross-validation. Default is 10.}

\item{ncv}{Number of repetitions of the cross-validation. Default is 10 for regression and 30 for classification.}

\item{num.rule.max}{Maximum number of rules of SIRUS model in the cross-validation grid. Default is 25.}

\item{q}{Number of quantiles used for node splitting in the forest construction. Default is 10.}

\item{num.trees.step}{Number of trees grown between two evaluations of the stopping criterion. Ignored if num.trees is provided.}

\item{alpha}{Parameter of the stopping criterion for the number of trees: stability has to reach 1 - alpha to stop the growing of the forest. Ignored if num.trees is provided.}

\item{mtry}{Number of variables to possibly split at each node. Default is the number of variables divided by 3.}

\item{max.depth}{Maximal tree depth. Default and strongly recommanded value is 2.}

\item{num.trees}{Number of trees grown in the forest. If NULL (recommanded), the number of trees is automatically set using a stability stopping criterion.}

\item{num.threads}{Number of threads used to grow the forest. Default is number of CPUs available.}

\item{replace}{Boolean. If true (default), sample with replacement.}

\item{sample.fraction}{Fraction of observations to sample. Default is 1 for sampling with replacement and 0.632 for sampling without replacement.}

\item{verbose}{Boolean. If true, information messages are printed.}

\item{seed}{Random seed. Default is NULL, which generates the seed from R. Set to 0 to ignore the R seed.}
}
\value{
Optimal value of p0 with the elements
  \item{\code{p0.pred}}{Optimal p0 value to maximize model accuracy.}
  \item{\code{p0.stab}}{Optimal p0 value for a tradeoff between stability and accuracy.}
  \item{\code{error.grid.p0}}{Table with the full cross-validation results for a fine grid of p0: number of rules, stability, error.}
  \item{\code{type}}{'reg' for regression, 'classif' for classification.}
}
\description{
Estimation by cross-validation of the hyperparameter p0 used to select rules in sirus.fit.
For a robust estimation, it is recommanded to run multiple cross-validations.
}
\examples{
## load sirus
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

## run cv
cv.grid <- sirus.cv(data, y, nfold = 3, ncv = 2, num.trees = 100)

}
