% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_system.R
\name{plotGRN}
\alias{plotGRN}
\title{Plots the GRN of the in silico system.}
\usage{
plotGRN(insilicosystem, edgeType = NULL, showAllVertices = F,
  plotType = "2D", ...)
}
\arguments{
\item{insilicosystem}{The in silico system (see \code{\link{createInSilicoSystem}}).}

\item{edgeType}{The type of interactions to plot. If NULL (default value), all the interactions are plotted. Otherwise, can be either:
\itemize{
\item "TC": plot only regulation of transcription
\item "TL": plot only regulation of translation
\item "RD": plot only regulation of RNA decay
\item "PD": plot only regulation of protein decay
\item "PTM": plot only regulation of protein post-translational modification
\item "RegComplexes": plot only binding interactions, i.e. linking the regulatory complexes to their components.
}}

\item{showAllVertices}{Display vertices that don't have any edge? Default is FALSE}

\item{plotType}{The type of plot function to use for the network: can be either
"2D" (default, use the function \code{\link[igraph]{plot.igraph}}), "interactive2D" (use the function
 \code{\link[igraph]{tkplot}}) or "interactive3D" (use the function \code{\link[igraph]{rglplot}}).}

\item{...}{any other arguments to be passed to the plot function, see \code{\link[igraph]{igraph.plotting}}.}
}
\description{
Plots the gene regulatory network of the insilico system, including all types of regulation or only those defined by the user.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 10)
plotGRN(mysystem)
plotGRN(mysystem, edgeType = "TC")
plotGRN(mysystem, edgeType = "TC", showAllVertices = T)
}
}
