% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/args_classes.R
\name{insilicoindividualargs}
\alias{insilicoindividualargs}
\title{Constructor function for the \code{insilicoindividualargs} class.}
\usage{
insilicoindividualargs(
  ngenevariants = 5,
  qtleffect_samplingfct = function(x) {     truncnorm::rtruncnorm(x, a = 0, b = Inf,
    mean = 1, sd = 0.1) },
  initvar_samplingfct = function(x) {     truncnorm::rtruncnorm(x, a = 0, b = Inf, mean
    = 1, sd = 0.1) }
)
}
\arguments{
\item{ngenevariants}{Integer. Number of alleles existing for each gene and segregating in the in silico population. Default value is 5.}

\item{qtleffect_samplingfct}{Function from which is sampled the value of a QTL effect coefficient (input x is the required sample size). Default value is a truncated normal distribution with mean 1 and sd 0.1 (only gives positive values).}

\item{initvar_samplingfct}{Function from which is sampled the variation of the initial abundance of a species (input x is the required sample size). Default value is a truncated normal distribution with mean 1 and sd 0.1 (only gives positive values).}
}
\value{
An object of the class \code{insilicoindividualargs}, that is a named list of the different parameters.
}
\description{
Constructor function for the \code{insilicoindividualargs} class, with default values for the parameters if not provided by the user.
}
\examples{
indargs = insilicoindividualargs(ngenevariants = 3)
}
