% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_classify_ts.R
\name{sits_show_prediction}
\alias{sits_show_prediction}
\title{Shows the predicted labels for a classified tibble}
\usage{
sits_show_prediction(class)
}
\arguments{
\item{class}{A SITS tibble that has been classified.}
}
\value{
Tibble with the columns "from", "to", "class"
}
\description{
This function takes a tibble with a classified time series
by a machine learning method and displays the result.
}
\examples{
if (sits_run_examples()) {
    # Retrieve the samples for Mato Grosso
    # train a tempCNN model
    ml_model <- sits_train(samples_modis_ndvi, ml_method = sits_tempcnn)
    # classify the point
    point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")
    point_class <- sits_classify(point_ndvi, ml_model)
    sits_show_prediction(point_class)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
