% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.probs_cube}
\alias{plot.probs_cube}
\title{Plot probability cubes}
\usage{
\method{plot}{probs_cube}(
  x,
  ...,
  tile = x$tile[[1]],
  labels = NULL,
  palette = "YlGnBu",
  rev = FALSE,
  tmap_options = NULL
)
}
\arguments{
\item{x}{Object of class "probs_image".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{labels}{Labels to plot (optional).}

\item{palette}{RColorBrewer palette}

\item{rev}{Reverse order of colors in palette?}

\item{tmap_options}{List with optional tmap parameters
tmap_max_cells (default: 1e+06)
tmap_graticules_labels_size (default: 0.7)
tmap_legend_title_size (default: 1.5)
tmap_legend_text_size (default: 1.2)
tmap_legend_bg_color (default: "white")
tmap_legend_bg_alpha (default: 0.5)}
}
\value{
A plot containing probabilities associated
                      to each class for each pixel.
}
\description{
plots a probability cube using stars
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # plot the resulting probability cube
    plot(probs_cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
