% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.som_clean_samples}
\alias{plot.som_clean_samples}
\title{Plot SOM samples evaluated}
\usage{
\method{plot}{som_clean_samples}(x, ...)
}
\arguments{
\item{x}{Object of class "som_clean_samples".}

\item{...}{Further specifications for \link{plot}.}
}
\value{
Called for side effects.
}
\description{
It is useful to visualise the
output of the SOM evaluation, which classifies the samples as
"clean" (good samples), "remove" (possible outliers),
and "analyse" (borderline cases). This function plots the
percentual distribution of the SOM evaluation per class.
To use it, please run \code{sits_som_clean_samples} using
the parameter "keep" as "c("clean", "analyze", "remove").
}
\examples{
if (sits_run_examples()) {
    # create a SOM map
    som_map <- sits_som_map(samples_modis_ndvi)
    # plot the SOM map
    eval <- sits_som_clean_samples(som_map)
    plot(eval)
}
}
\author{
Estefania Pizarro, \email{eapizarroa@ine.gob.cl}
}
