% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_tabla_incidencia_geo}
\alias{plot_tabla_incidencia_geo}
\title{Generar tabla con la incidencia}
\usage{
plot_tabla_incidencia_geo(data_agrupada, col_geo = NULL)
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la
enfermedad o evento agrupados por departamento o municipio.}

\item{col_geo}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene los nombres de los departamentos o municipios
en los datos agrupados de la enfermedad o evento; su valor por
defecto es `NULL`.}
}
\value{
Una `kable` (tabla gráfica) con la incidencia según
distribución geográfica.
}
\description{
Función que genera la tabla con la incidencia según la
distribución geográfica.
}
\examples{
\donttest{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
data_agrupada <- agrupar_mpio(data_limpia, dpto = "Antioquia")
incidencia_mpios <- calcular_incidencia_geo(
  data_agrupada =
    data_agrupada,
  ruta_dir = tempdir()
)
plot_tabla_incidencia_geo(
  data_agrupada = incidencia_mpios$data_incidencia,
  col_geo = "municipio_ocurrencia"
)
}
}
