% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjStatistics.R
\name{sjs.stdb}
\alias{sjs.stdb}
\title{Retrieve std. beta coefficients and ci of lm}
\usage{
sjs.stdb(fit, include.ci = FALSE)
}
\arguments{
\item{fit}{A fitted linear model.}

\item{include.ci}{logical, if \code{TRUE}, a data frame with confidence intervals will be returned.}
}
\value{
A vector with standardiized beta coefficients of the fitted linear model, or a data frame
          with standardiized confidence intervals, if \code{include.ci = TRUE}.
}
\description{
Returns the standardized beta coefficients and confidence intervals of a fitted linear model.
}
\note{
"Standardized coefficients refer to how many standard deviations a dependent variable will change,
        per standard deviation increase in the predictor variable. Standardization of the coefficient is
        usually done to answer the question of which of the independent variables have a greater effect
        on the dependent variable in a multiple regression analysis, when the variables are measured
        in different units of measurement (for example, income measured in dollars and family size
        measured in number of individuals)." (Source: Wikipedia)
}
\examples{
# fit linear model
fit <- lm(airquality$Ozone ~ airquality$Wind + airquality$Temp + airquality$Solar.R)
# print std. beta coefficients
sjs.stdb(fit)

# print std. beta coefficients and ci
sjs.stdb(fit, include.ci = TRUE)
}
\references{
\href{http://en.wikipedia.org/wiki/Standardized_coefficient}{Wikipedia: Standardized coefficient}
}
\seealso{
\itemize{
           \item \code{\link{sjp.lm}}
           \item \code{\link{sjt.lm}}
           }
}

