% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotCorr.R
\name{sjp.corr}
\alias{sjp.corr}
\title{Plot correlation matrix}
\usage{
sjp.corr(data, title = NULL, axisLabels = NULL, type = "circle",
  sortCorrelations = TRUE, decimals = 3, missingDeletion = "listwise",
  corMethod = "spearman", geom.colors = "RdBu", geom.size = 15,
  breakTitleAt = 50, breakLabelsAt = 20, hideLegend = TRUE,
  legendTitle = NULL, showValueLabels = TRUE, showPValues = TRUE,
  pvaluesAsNumbers = FALSE, printPlot = TRUE)
}
\arguments{
\item{data}{a matrix with correlation coefficients as returned by the
\code{\link{cor}}-function, or a \code{\link{data.frame}} of variables that
should be correlated.}

\item{title}{plot title as string.}

\item{axisLabels}{Labels for the x- andy y-axis.
axisLabels are detected automatically if \code{data} is a \code{\link{data.frame}}
where each variable has a variable label attribute (see \code{\link[sjmisc]{set_var_labels}})
for details).}

\item{type}{Indicates whether the geoms of correlation values should be plotted
as \code{"circle"} (default) or as \code{"tile"}.}

\item{sortCorrelations}{If \code{TRUE} (default), the axis labels are sorted
according to the correlation strength. If \code{FALSE}, axis labels
appear in order of how variables were included in the cor-computation or
data frame.}

\item{decimals}{Indicates how many decimal values after comma are printed when
the values labels are shown. Default is 3. Only applies when
\code{showValueLabels} is \code{TRUE}.}

\item{missingDeletion}{Indicates how missing values are treated. May be either
\code{"listwise"} (default) or \code{"pairwise"}.}

\item{corMethod}{Indicates the correlation computation method. May be one of
\code{"spearman"} (default), \code{"pearson"} or \code{"kendall"}.}

\item{geom.colors}{A color palette for fillng the geoms. If not specified, the 5th diverging color palette
from the color brewer palettes (RdBu) is used, resulting in red colors for negative and blue colors
for positive correlations, that become lighter the weaker the correlations are. Use any
color palette that is suitbale for the \code{scale_fill_gradientn} parameter of ggplot2.}

\item{geom.size}{Specifies the circle size factor. The circle size depends on the correlation
value multiplicated with this factor. Default is 15.}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title. Default is 50.}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted. Default is 12.}

\item{hideLegend}{Show or hide the legend. The legend indicates the strength of correlations
by gradient colour fill. Default is \code{TRUE}, hence the legend is hidden.}

\item{legendTitle}{The legend title, provided as string, e.g. \code{legendTitle=c("Strength of correlation")}.
Default is \code{NULL}, hence no legend title is used.}

\item{showValueLabels}{Whether correlation values should be plotted to each geom}

\item{showPValues}{Whether significance levels (p-values) of correlations should
be plotted to each geom. See 'Note'.}

\item{pvaluesAsNumbers}{If \code{TRUE}, the significance levels (p-values) are printed as numbers.
if \code{FALSE} (default), asterisks are used. See 'Note'.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}) and the original correlation matrix
          (\code{corr.matrix}).
}
\description{
Plot correlation matrix as ellipses or tiles. Required parameter is either
               a \code{\link{data.frame}} or a matrix with correlation coefficients
               as returned by the \code{\link{cor}}-function. In case of ellipses, the
               ellipses size indicates the strength of the correlation. Furthermore,
               blue and red colors indicate positive or negative correlations, where
               stronger correlations are darker.
}
\note{
If \code{data} is a matrix with correlation coefficients as returned by
      the \code{\link{cor}}-function, p-values can't be computed.
      Thus, \code{showPValues} and \code{pvaluesAsNumbers}
      only have an effect if \code{data} is a \code{\link{data.frame}}.
}
\examples{
# create data frame with 5 random variables
mydf <- data.frame(cbind(runif(10),
                         runif(10),
                         runif(10),
                         runif(10),
                         runif(10)))

# plot correlation matrix using circles
sjp.corr(mydf)

# plot correlation matrix using square tiles without diagram background
sjp.corr(mydf, type = "tile")


# -------------------------------
# Data from the EUROFAMCARE sample dataset
# -------------------------------
library(sjmisc)
data(efc)

# retrieve variable and value labels
varlabs <- get_var_labels(efc)

# create data frame
vars.index <- c(1, 4, 15, 19, 20, 21, 22, 24, 25)
mydf <- data.frame(efc[, vars.index])
colnames(mydf) <- varlabs[vars.index]

# show legend
sjp.corr(mydf, type = "tile", hideLegend = FALSE)

# -------------------------------
# auto-detection of labels
# -------------------------------
# blank theme
sjp.setTheme(theme = "blank", axis.angle.x = 90)
sjp.corr(efc[, vars.index])
}
\seealso{
\code{\link{sjt.corr}}
}

