% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{get_var_labels}
\alias{get_var_labels}
\title{Retrieve variable labels of a data frame or variable}
\usage{
get_var_labels(x)
}
\arguments{
\item{x}{a \code{data.frame} with variables that have attached variable labels (e.g.
         from an imported SPSS, SAS or STATA data set, via \code{\link{read_spss}},
         \code{\link{read_sas}} or \code{\link{read_stata}}); a variable
         (vector) with attached variable label; or a \code{list} of variables
         with attached variable labels. See 'Examples'.}
}
\value{
A named char vector with all variable labels from the data frame or list;
          or a simple char vector (of length 1) with the variable label, if \code{x} is a variable.
}
\description{
This function retrieves the value labels of an imported
               SPSS, SAS or STATA data set (via \code{\link{read_spss}},
               \code{\link{read_sas}} or \code{\link{read_stata}}) and
               \itemize{
                 \item if \code{x} is a data frame or a list of variables, returns the all variable labels as names character vector of length \code{ncol(x)}.
                 \item or, if \code{x} is a vector, returns the variable label as string.
                 }
}
\details{
See 'Details' in \code{\link{get_val_labels}}.
}
\note{
See 'Note' in \code{\link{get_val_labels}}.
}
\examples{
# import SPSS data set
# mydat <- read_spss("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- get_var_labels(mydat)

# retrieve value labels
# mydat.val <- get_val_labels(mydat)

data(efc)

# get variable lable
get_var_labels(efc$e42dep)

# alternative way
get_var_labels(efc)["e42dep"]

# simple barplot
barplot(table(efc$e42dep))
# get value labels to annotate barplot
barplot(table(efc$e42dep),
        names.arg = get_val_labels(efc$e42dep),
        main = get_var_labels(efc$e42dep))

# get labels from multiple variables
get_var_labels(list(efc$e42dep,
                    efc$e16sex,
                    efc$e15relat))
}
\seealso{
The sjPlot manual on \href{http://www.strengejacke.de/sjPlot/datainit/}{data initialization} or
           \href{http://www.strengejacke.de/sjPlot/view_spss/}{inspecting (SPSS imported) data frames} for
           more details; \code{\link{set_var_labels}} to manually set variable labels or \code{\link{get_val_labels}}
           to get value labels.
}

