% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_factor.R
\name{to_factor}
\alias{to_fac}
\alias{to_factor}
\title{Convert variable into factor and keep value labels}
\usage{
to_factor(x, add.non.labelled = FALSE, drop.na = TRUE, ref.lvl = NULL)

to_fac(x, add.non.labelled = FALSE, drop.na = TRUE, ref.lvl = NULL)
}
\arguments{
\item{x}{numeric or atomic variable or a data frame with
numeric or atomic variables.}

\item{add.non.labelled}{logical, if \code{TRUE}, non-labelled values also
get value labels.}

\item{drop.na}{logical, if \code{TRUE}, all types of missing value codes are
converted into NA before \code{x} is converted as factor. If
\code{FALSE}, missing values will be left as their original codes.
See 'Examples' and \code{\link{get_na}}.}

\item{ref.lvl}{Numeric, specifies the reference level for the new factor. Use
this parameter if a different factor level than the lowest value
should be used as reference level. If \code{NULL}, lowest value
will become the reference level. See \code{\link{ref_lvl}} for
details.}
}
\value{
A factor variable, including variable and value labels, respectively
          a data frame with factor variables (including variable and value labels)
          if \code{x} was a data frame.
}
\description{
This function converts a variable into a factor, but preserves
               variable and value label attributes. See 'Examples'.
}
\details{
See 'Details' in \code{\link{get_na}}.
}
\note{
This function is intended for use with vectors that have value and variable
       label attributes. Unlike \code{\link{as.factor}}, \code{to_factor} converts
       a variable into a factor and preserves the value and variable label attributes.
       \cr \cr
       Adding label attributes is automatically done by importing data sets
       with one of the \code{read_*}-functions, like \code{\link{read_spss}}.
       Else, value and variable labels can be manually added to vectors
       with \code{\link{set_labels}} and \code{\link{set_label}}.
}
\examples{
\dontrun{
data(efc)
library(sjPlot)
# normal factor conversion, loses value attributes
efc$e42dep <- as.factor(efc$e42dep)
sjt.frq(efc$e42dep)

# factor conversion, which keeps value attributes
efc$e42dep <- to_factor(efc$e42dep)
sjt.frq(efc$e42dep)}

data(efc)
# create parially labelled vector
x <- set_labels(efc$e42dep,
                c(`1` = "independent",
                  `4` = "severe dependency",
                  `9` = "missing value"))

# only copy existing value labels
to_factor(x)
get_labels(to_factor(x), include.values = "p")

# also add labels to non-labelled values
to_factor(x, add.non.labelled = TRUE)
get_labels(to_factor(x, add.non.labelled = TRUE), include.values = "p")

# create labelled integer, with missing flag
x <- labelled(c(1, 2, 1, 3, 4, 1),
              c(Male = 1, Female = 2, Refused = 3, "N/A" = 4),
              c(FALSE, FALSE, TRUE, TRUE))
# to factor, with missing labels
to_factor(x, drop.na = FALSE)
# to factor, missings removed
to_factor(x, drop.na = TRUE)


# Convert to factor, using different reference level
x <- to_factor(efc$e42dep)
str(x)
table(x)

x <- to_factor(efc$e42dep, ref.lvl = 3)
str(x)
table(x)

}
\seealso{
\code{\link{to_value}} to convert a factor into a numeric value and
           \code{\link{to_label}} to convert a value into a factor with labelled
           factor levels.
}

