% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_dummy.R
\name{to_dummy}
\alias{to_dummy}
\title{Split (categorical) vectors into dummy variables}
\usage{
to_dummy(x, var.name = "name", suffix = "numeric", data = NULL)
}
\arguments{
\item{x}{a \code{\link{factor}}.}

\item{var.name}{indicates how the new dummy variables are named. Use
\code{"name"} to use the variable name or any other string that will
be used as is. See 'Examples'.}

\item{suffix}{indicates which suffix will be added to each dummy variable.
Use \code{"numeric"} to number dummy variables, e.g. \emph{x_1},
\emph{x_2}, \emph{x_3} etc. Use \code{"label"} to add value label,
e.g. \emph{x_low}, \emph{x_mid}, \emph{x_high}. May be abbreviated.}

\item{data}{optional, a data frame where the new dummy variables are appended
as additional columns.}
}
\value{
A data frame with dummy variables for each category of \code{x}, or
          \code{data} where new dummy variables are appended as additional
          columns. The dummy coded variables are of type \code{\link{atomic}}.
}
\description{
This function splits categorical or numeric vectors with
               more than two categories into 0/1-coded dummy variables.
}
\note{
\code{NA} values will be copied from \code{x}, so each dummy variable
        has the same amount of \code{NA}'s at the same position as \code{x}.
}
\examples{
data(efc)
head(to_dummy(efc$e42dep))

# add value label as suffix to new variable name
head(to_dummy(efc$e42dep, suffix = "label"))

# use "dummy" as new variable name
head(to_dummy(efc$e42dep, var.name = "dummy"))

}

