% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frq.R
\name{get_frq}
\alias{get_frq}
\title{Get summary of labelled vectors}
\usage{
get_frq(x, coerce = TRUE)
}
\arguments{
\item{x}{A labelled vector.}

\item{coerce}{Logical, if \code{TRUE}, vectors will be coerced to \code{labelled}
class if necessary.}
}
\value{
A data frame with the summary information of \code{x}.
}
\description{
This function returns a summary, including frequency table,
               of labelled vectors, as data frame. Unlike \code{\link{summary}}, the
               \code{frq} method also prints label and missing attributes.
}
\examples{
# create labelled factor, with missing flag
x <- labelled(c("M", "M", "F", "X", "N/A"),
              c(Male = "M", Female = "F",
                Refused = "X", "Not applicable" = "N/A"),
              c(FALSE, FALSE, TRUE, TRUE))

get_frq(x)

}

