% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.R
\name{se}
\alias{se}
\title{Standard Error for variables or coefficients}
\usage{
se(x, nsim = 100)
}
\arguments{
\item{x}{(Numeric) vector, a data frame, a \code{merMod}-object
as returned by the \code{\link[lme4]{lmer}}-method,
or a list with estimate and p-value. For the latter case, the list
must contain elements named \code{estimate} and \code{p.value}
(see 'Examples' and 'Details').}

\item{nsim}{Numeric, the number of simulations for calculating the
standard error for intraclass correlation coefficients, as
obtained by the \code{\link{icc}}-function.}
}
\value{
The standard error of \code{x}, or for each variable
          if \code{x} is a data frame, or for the coefficients
          of a mixed model (see \code{\link[lme4]{coef.merMod}}).
}
\description{
Compute standard error for a variable, for all variables
               of a data frame, for joint random and fixed effects
               coefficients of mixed models, or for intraclass correlation
               coefficients (ICC).
}
\details{
Unlike \code{\link[arm]{se.coef}}, which returns the standard error
           for fixed and random effects separately, this function computes
           the standard errors for joint (sums of) random and fixed
           effects coefficients. Hence, \code{se} returns the appropriate
           standard errors for \code{\link[lme4]{coef.merMod}}.
           \cr \cr
           The standard error for the \code{\link{icc}} is based on bootstrapping,
           thus, the \code{nsim}-argument is required. See 'Examples'.
           \cr \cr
           \code{se} also returns the standard error of an estimate (regression
           coefficient) and p-value, assuming a normal distribution to compute
           the z-score from the p-value (formula in short: \code{b / qnorm(p / 2)}).
}
\note{
Computation of standard errors for coefficients of mixed models
        is based \href{http://stackoverflow.com/questions/26198958/extracting-coefficients-and-their-standard-error-from-lme}{on this code}.
}
\examples{
se(rnorm(n = 100, mean = 3))

data(efc)
se(efc[, 1:3])

library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
se(fit)

# compute standard error from regression coefficient and p-value
se(list(estimate = .3, p.value = .002))

\dontrun{
# compute standard error of ICC for the linear mixed model
icc(fit)
se(icc(fit))

# the standard error for the ICC can be computed manually in this way,
# taking the fitted model example from above
library(dplyr)
dummy <- sleepstudy \%>\%
  # generate 100 bootstrap replicates of dataset
  bootstrap(100) \%>\%
  # run mixed effects regression on each bootstrap replicate
  mutate(models = lapply(.$strap, function(x) {
    lmer(Reaction ~ Days + (Days | Subject), data = x)
  })) \%>\%
  # compute ICC for each "bootstrapped" regression
  mutate(icc = unlist(lapply(.$models, icc)))
# now compute SE and p-values for the bootstrapped ICC, values
# may differ from above example due to random seed
boot_se(dummy, icc)
boot_p(dummy, icc)}


}

