% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_ibd}
\alias{read_ibd}
\title{Read IBD segment file}
\usage{
read_ibd(file, source)
}
\arguments{
\item{file}{Input file path}

\item{source}{Source of the input file; must be one of \code{"hapibd"} or \code{"pedsim"}}
}
\value{
if \code{source="hapibd"}, a tibble is returned.
If \code{source="pedsim"}, a list with two tibble elements, \code{IBD1} and \code{IBD2} is returned.
Both the \code{hapibd} tibble, and the two \code{pedsim} tibbles contain six columns:
\enumerate{
\item id1 (sample identifier 1)
\item id2 (sample identifier 2)
\item chr (chromosome)
\item start (segment bp start coordinate)
\item end (segment bp end coordinate)
\item length (shared segment length in genetic units, cM)
}
}
\description{
Reads in the inferred IBD segments from \code{hapibd} (\href{https://github.com/browning-lab/hap-ibd#output-files}{documentation}) or IBD segment file generated by \code{ped-sim} (\href{https://github.com/williamslab/ped-sim#output-ibd-segments-file}{documentation}).

If reading a \code{hapibd} segment file, the input data should have the following columns:
\enumerate{
\item First sample identifier
\item First sample haplotype index (1 or 2)
\item Second sample identifier
\item Second sample haplotype index (1 or 2)
\item Chromosome
\item Base coordinate of first marker in segment
\item Base coordinate of last marker in segment
\item cM length of IBD segment
}

If read a \code{pedsim} segment file, the input data should have the following columns:
\enumerate{
\item First sample identifier
\item Second sample identifer
\item Chromosome
\item Physical position start
\item Physical position end
\item IBD type
\item Genetic position start
\item Genetic position end
\item Genetic length (end - start)
}
}
\examples{
hapibd_fp <- system.file("extdata", "GBR.sim.ibd.gz", package="skater", mustWork=TRUE)
hapibd_seg <- read_ibd(hapibd_fp, source = "hapibd")
pedsim_fp <- system.file("extdata", "GBR.sim.seg.gz", package="skater", mustWork=TRUE)
pedsim_seg <- read_ibd(pedsim_fp, source = "pedsim")
}
\references{
\url{https://github.com/browning-lab/hap-ibd#output-files}

\url{https://github.com/williamslab/ped-sim#output-ibd-segments-file}
}
