% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/li_yao.R
\name{li_yao}
\alias{li_yao}
\title{Li-Yao ALRT and CVT Tests for Heteroskedasticity in a Linear Regression Model}
\usage{
li_yao(mainlm, method = "alrt")
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} "lm", or a list
of two components: a response vector and a design matrix (in that order).
If the latter, the design matrix must begin with a column of 1s if an
intercept is to be included in the linear model. Passing an object of
class "lm" is recommended in applications; passing a list containing
the data is recommended where optimising computational performance is
important.}

\item{method}{A character indicating which of the two tests derived in
\insertCite{Li19;textual}{skedastic} should be implemented. Possible
values are "alrt" (approximate likelihood-ratio test) and "cvt"
(coefficient-of-variation test). Default is "alrt". It is acceptable to
specify only the first letter.}
}
\value{
An object of \code{\link[base]{class}} "htest". If object is not
   assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the two methods of
   \insertCite{Li19;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
These two tests are straightforward to implement; in both cases the test
    statistic is a function only of the residuals of the linear regression
    model. Furthermore, in both cases the test statistic is asymptotically
    normally distributed under the null hypothesis of homoskedasticity.
    Both tests are right-tailed. These tests are designed to be especially
    powerful in high-dimensional regressions, i.e. when the number of
    explanatory variables is large.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
li_yao(mtcars_lm, method = "alrt")
li_yao(mtcars_lm, method = "cvt")

}
\references{
{\insertAllCited{}}
}
