% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_multibestmodel.R
\name{modeltime_multibestmodel}
\alias{modeltime_multibestmodel}
\title{Gets the best model from a modeltime table}
\usage{
modeltime_multibestmodel(
  .table,
  .metric = NULL,
  .minimize = TRUE,
  .forecast = TRUE
)
}
\arguments{
\item{.table}{'table_time**' tibble generated with the \code{modeltime_multifit()} function.}

\item{.metric}{evaluation metric, from \code{modeltime_accuracy()} of 'modeltime' package: 'mae', 'mape','mase','smape','rmse','rsq'.}

\item{.minimize}{boolean (default = TRUE), TRUE if the error metric should be minimized, FALSE in order to maximize it.}

\item{.forecast}{boolean (default = TRUE), If it is TRUE, it indicates that the \verb{modeltime_multi forecast()}
function has already been applied to the object that enters the "\strong{.table}" parameter.
This is evaluated by the existence of the column "nested_forecast".}
}
\value{
table_time tibble filtered by the best model.
}
\description{
this feature allows you to select the best model for each series, based on a specific evaluation metric.
}
\details{
take the object 'table_time' from the output of the function \code{modeltime_multifit()},
and selects the best model based on the selected metric.
}
\examples{
# Data
data_serie <- sknifedatar::table_time
                                      
# best_model_emae
sknifedatar::modeltime_multibestmodel(.table = data_serie$table_time,
                                      .metric = "rmse",
                                      .minimize = TRUE,
                                      .forecast = FALSE)

}
