% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_multiforecast.R
\name{modeltime_wfs_multiforecast}
\alias{modeltime_wfs_multiforecast}
\title{Forecast of a workflow set on multiple time series}
\usage{
modeltime_wfs_multiforecast(models_table, .h = NULL, .prop = NULL)
}
\arguments{
\item{models_table}{a tibble that comes from the output of the \code{modeltime_wfs_multifit()}, \code{modeltime_wfs_multirefit()},
\code{modeltime_wfs_multibestmodel()} functions. For the \code{modeltime_wfs_multifit()} function,
the 'table_time' object must be selected from the output.}

\item{.h}{prediction horizon of the \code{modeltime_forecast()} function of the 'modeltime' package.}

\item{.prop}{decimal number, time series split partition ratio. If ".h" is specified, this function
predicts on the testing partition.}
}
\value{
a tibble, corresponds to the same tibble supplied in the 'models_table' parameter but with an additional
column called 'nested_forecast' where the nested previews of the workflows on all the time series are stored.
}
\description{
generates forecasts of a workflow set object over multiple time series.
}
\examples{
library(dplyr)
library(earth)

df <- sknifedatar::emae_series

datex <- '2020-02-01'
df_emae <- df \%>\%
  dplyr::filter(date <= datex) \%>\% 
  tidyr::nest(nested_column=-sector) \%>\% head(2)

receta_base <- recipes::recipe(value ~ ., data = df \%>\% select(-sector))

mars <- parsnip::mars(mode = 'regression') \%>\% parsnip::set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    R_date = receta_base),
  models  = list(M_mars = mars),
  cross   = TRUE)

wfsets_fit <- sknifedatar::modeltime_wfs_multifit(.wfs = wfsets,
                                                  .prop = 0.8, 
                                                  serie = df_emae)

sknifedatar::modeltime_wfs_multiforecast(wfsets_fit$table_time,
                                         .prop=0.8)

}
