% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertRaw.R
\name{convertRaw}
\alias{convertRaw}
\title{Convert Raw}
\usage{
convertRaw(x, y, path = NULL)
}
\arguments{
\item{x}{First csv file to be processed}

\item{y}{Second csv file to be processed}

\item{path}{Path to save file to}
}
\description{
Converts DB1B files from BTS/RITA/Transtats website raw data (prezipped file), for SKYNET's import function.
}
\details{
Reduces DB1B raw filesize, to an adequate SKYNET compatible format. This function will create a csv file for you.
File order doesn't matter, but it is recommended to name the files using the following
syntax: \emph{"Origin_and_Destination_Survey_DB1BCoupon_year_quarter.csv", "Origin_and_Destination_Survey_DB1BTicket_year_quarter.csv".}
Note: We do recommend sparklyr to be used for larger sets of data.
}
\examples{
\dontrun{

temp <- tempdir()
convertRaw(skynet_example("Origin_and_Destination_Survey_DB1BCoupon_2001_1.csv"),
skynet_example("Origin_and_Destination_Survey_DB1BTicket_2001_1.csv"),
path = temp)

}

}
