% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_setup.r
\name{slackr_setup}
\alias{slackr_setup}
\title{Setup environment variables for Slack API access}
\usage{
slackr_setup(
  channel = "#general",
  username = "slackr",
  icon_emoji = "",
  incoming_webhook_url = "",
  token = "",
  config_file = "~/.slackr",
  echo = FALSE,
  cache_dir = ""
)
}
\arguments{
\item{channel}{default channel to send the output to (chr) defaults to \verb{#general}.}

\item{username}{the username output will appear from (chr) defaults to \code{slackr}.}

\item{icon_emoji}{which emoji picture to use (chr) defaults to none (can be
left blank in config file as well).}

\item{incoming_webhook_url}{the Slack URL prefix to use (chr) defaults to none.}

\item{token}{Authentication token bearing required scopes.}

\item{config_file}{a configuration file (DCF) - see \link{read.dcf} - format
with the config values.}

\item{echo}{display the configuration variables (bool) initially \code{FALSE}.}

\item{cache_dir}{the location for an on-disk cache. defaults to an in-memory cache if no location is specified.}
}
\value{
"Successfully connected to Slack"
}
\description{
Initialize all the environment variables \code{\link[=slackr]{slackr()}} will need to use to
work properly.
}
\details{
By default, \code{\link[=slackr]{slackr()}} (and other functions) will use the \verb{#general}
room and a username of \code{slackr()} with no emoji.

If a valid file is found at the locaiton pointed to by \code{config_file}, the
values there will be used. The fields should be specified as such in the file:

\preformatted{
 token: SLACK_TOKEN
 channel: #general
 username: slackr
 incoming_webhook_url: https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX
}
}
\note{
You need a \href{https://slack.com}{Slack} account and all your API URLs & tokens setup
to use this package.
}
\examples{
\dontrun{
# reads from default file (i.e. ~/.slackr)
slackr_setup()

# reads from alternate config
slackr_setup(config_file="/path/to/my/slackrconfig)

# the hard way
slackr_setup(channel="#code",
  incoming_webhook_url="https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX")
}
}
\seealso{
\code{\link[=slackr]{slackr()}}, \code{\link[=slackr_dev]{slackr_dev()}}, \code{\link[=slackr_save]{slackr_save()}},
\code{\link[=slackr_upload]{slackr_upload()}}
}
