% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{slash}
\alias{slash}
\title{Path-based access and manipulation for R lists}
\description{
Path-based access and manipulation for R lists

Path-based access and manipulation for R lists
}
\details{
The slash class provides tools for working with hierarchical R lists using
path-like strings (e.g., "a/b/c"). Rather than creating a new data structure,
it adds convenient path-based access methods to standard R lists, supporting:
- Both named and numeric (1-based) indexing
- Strict mode for error checking
- Various operations for list manipulation
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-slash-new}{\code{slash$new()}}
\item \href{#method-slash-get}{\code{slash$get()}}
\item \href{#method-slash-set}{\code{slash$set()}}
\item \href{#method-slash-exists}{\code{slash$exists()}}
\item \href{#method-slash-delete}{\code{slash$delete()}}
\item \href{#method-slash-clear}{\code{slash$clear()}}
\item \href{#method-slash-get_all}{\code{slash$get_all()}}
\item \href{#method-slash-print}{\code{slash$print()}}
\item \href{#method-slash-print_list}{\code{slash$print_list()}}
\item \href{#method-slash-list_paths}{\code{slash$list_paths()}}
\item \href{#method-slash-is_strict}{\code{slash$is_strict()}}
\item \href{#method-slash-set_strict}{\code{slash$set_strict()}}
\item \href{#method-slash-clone}{\code{slash$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-new"></a>}}
\if{latex}{\out{\hypertarget{method-slash-new}{}}}
\subsection{Method \code{new()}}{
Create a new slash object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$new(data = list(), strict = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Initial data (must be a list)}

\item{\code{strict}}{If TRUE, attempts to access non-existent paths will error}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `slash` object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-get"></a>}}
\if{latex}{\out{\hypertarget{method-slash-get}{}}}
\subsection{Method \code{get()}}{
Get value at specified path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$get(path = NULL, default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to the element (e.g., "a/b/c" or "1/2/3")}

\item{\code{default}}{Value to return if path doesn't exist (NULL by default)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value at the specified path, or default if not found
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-set"></a>}}
\if{latex}{\out{\hypertarget{method-slash-set}{}}}
\subsection{Method \code{set()}}{
Set value at specified path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$set(path, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to the element}

\item{\code{value}}{Value to set}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The slash object (invisibly) for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-exists"></a>}}
\if{latex}{\out{\hypertarget{method-slash-exists}{}}}
\subsection{Method \code{exists()}}{
Check if path exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$exists(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if path exists, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-delete"></a>}}
\if{latex}{\out{\hypertarget{method-slash-delete}{}}}
\subsection{Method \code{delete()}}{
Delete element at specified path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$delete(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to delete}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The slash object (invisibly) for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-clear"></a>}}
\if{latex}{\out{\hypertarget{method-slash-clear}{}}}
\subsection{Method \code{clear()}}{
Clear all data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The slash object (invisibly) for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-get_all"></a>}}
\if{latex}{\out{\hypertarget{method-slash-get_all}{}}}
\subsection{Method \code{get_all()}}{
Get all data as a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$get_all()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The complete data structure
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-print"></a>}}
\if{latex}{\out{\hypertarget{method-slash-print}{}}}
\subsection{Method \code{print()}}{
Print summary of slash object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$print(show_full = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_full}}{If TRUE, shows full structure (FALSE by default)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-print_list"></a>}}
\if{latex}{\out{\hypertarget{method-slash-print_list}{}}}
\subsection{Method \code{print_list()}}{
Print list structure at path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$print_list(path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to print (NULL for root)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-list_paths"></a>}}
\if{latex}{\out{\hypertarget{method-slash-list_paths}{}}}
\subsection{Method \code{list_paths()}}{
List all available paths
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$list_paths()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of all paths in the data structure
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-is_strict"></a>}}
\if{latex}{\out{\hypertarget{method-slash-is_strict}{}}}
\subsection{Method \code{is_strict()}}{
Check if in strict mode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$is_strict()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if in strict mode, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-set_strict"></a>}}
\if{latex}{\out{\hypertarget{method-slash-set_strict}{}}}
\subsection{Method \code{set_strict()}}{
Set strict mode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$set_strict(strict)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{strict}}{Logical value for strict mode}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The slash object (invisibly) for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-slash-clone"></a>}}
\if{latex}{\out{\hypertarget{method-slash-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{slash$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
