% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trending_players.R
\name{plot_trending_players}
\alias{plot_trending_players}
\title{Plot Trending NFL Player Information}
\usage{
plot_trending_players(
  lookback_hours = 24,
  limit = 10,
  tick_color = "black",
  title = "Trending Adds/Drops",
  drop_fill = "#f68383",
  add_fill = "lightgreen"
)
}
\arguments{
\item{lookback_hours}{Number of hours to look back (numeric).}

\item{limit}{Number of results you would like (numeric).}

\item{tick_color}{Font color, name or hex, for display names (string).}

\item{title}{Plot title - default is "Trending Adds/Drops" (string).}

\item{drop_fill}{Bar color, name or hex, for drops (string).}

\item{add_fill}{Bar color, name or hex, for adds (string).}
}
\value{
Returns a plot containing information (name and
        count) about the trending players.
}
\description{
Given the number of hours to look back, a limit of
how many players to return, a color for labels, and a
title, display a figure showing the top NFL additions and drops.
}
\examples{
\dontrun{plot_trending_players(lookback_hours = 24, limit = 10)}
\dontrun{plot_trending_players(lookback_hours = 24, limit = 10, tick_color = "white")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, September 2023
}
\keyword{players}
\keyword{trending}
