%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:18:16.
% Do NOT modify this file, instead modify the source (sma/R/Rmva.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.mva}

\alias{plot.mva}
  
\title{M vs. A Plot}

\description{
For a single slide, this function produces a scatter plot of log
intensity ratios \eqn{M = log_2(R/G)} versus average log intensities
\eqn{A = log_2 \sqrt{RG}}{A = log_2(R*G)/2}, where R and G represent
the fluorescence intensities in the red and green channels
respectively. 
}

\usage{
plot.mva(RG, layout, norm="p", pout=T, image.id=1, extra.type="tci",
crit1=0.025,crit2=crit1, nclass=10, labs=NULL, plot.type="n",
col.ex=NULL, ...) 
}

\arguments{
  \item{RG}{A list with at least 4 elements.  Each element of the list
    being a matrix with p rows for p genes and n columns for n slides. 
    The first element 'R' contains the raw red intensities,
    the second element 'G' contains the raw green intensities,
    the third element 'Rb' contains the background red intensities and
    the 4th element 'Gb' contains the background green intensities.
    This data structure can be generated by an interactive function
    \code{\link{init.data}}.}  

  \item{layout}{a list specifying the dimensions of the spot matrix
  and the grid matrix.  This can be generated by calling
  \code{\link{init.grid}}.} 

  \item{norm}{character string, one of "n", "m", "l", "p" or "s".  This
    argument  specifies the type of normalization method to be
    performed: "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization.} 
  
  \item{pout}{if TRUE, an M vs. A plot will be produced.  Otherwise, the
    function returns the normalized log intensity ratios M and the mean
    log intensities A for each gene.} 
  
  \item{image.id}{integer value; the index of the slide which is considered.}

  \item{extra.type}{a character string, one of "t", "p", "tci","pci" or
    "lci".  This argument specifies the type of plot to be drawn.  The
    possible types are: \cr
    * "t" for text, \cr
    * "p" for points, \cr
    * "tci" for highlighting a certain proportion of extreme `M' values
    by text,\cr
    * "pci" for highlighting a certain proportion of extreme `M' values
    by points,\cr
    * "lci" for including 2 intensity dependent lines where a 
    prespecified proportion of points have more extreme `M' values. 
  }
  \item{crit1}{The number of points to be highlighted on the M vs A
    plot.  If crit1 < 1, the crit1*100\% spots with the smallest M
    values will be highlighted. If crit1 >= 1, the crit spots 
   with the smallest M values are highlighted.} 
 \item{crit2}{Similar to "crit1".   If crit2 < 1, the crit2*100\% spots
   with the largest M values will be highlighted. If crit2 >= 1, the
   crit2 spots with the smallest M values are highlighted.}
 \item{nclass}{A single number giving the approximate number of
   intensity dependent groups to consider.}
 \item{labs}{one or more character strings or expressions specifying the
   text to be written.  If this string is not specified, by
   default the index of the vector `M' will be used.}
 \item{plot.type}{a character string, this argument is either "n", "r"
   or "b".  The different number of plots to be included are:\cr
   * "n" for normalised M vs A plot, \cr
   * "r" for unnormalised M vs A plot, and \cr 
   * "b" both unnormalised and normalised M vs A plots.
  }
 \item{col.ex}{The colour used for the highlighting extreme points,
 lines or text.} 
 \item{\dots}{graphical parameters may also be supplied as arguments to the
    function (see \code{\link{par}}).  }
}

\value{A plot is created on the current graphics device.  The top
plot is based on unnormalized log ratios and the bottom plot is
based on normalized log ratios.} 

\details{M vs. A plots tend to be more revealing than their log R
vs. log G counterparts in terms of identifying spot artifacts and
detecting intensity dependent patterns in the log ratios. They are
also very useful for normalization.} 

\references{S. Dudoit, Y. H. Yang, M. J. Callow, and T. P. Speed. Statistical
methods for identifying differentially expressed genes in replicated
cDNA microarray experiments (Statistics, UC Berkeley, Tech Report \#
578).}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Natalie Roberts, \email{nroberts@wehi.edu.au}
}

\seealso{\code{\link{ma.func}}, \code{\link{plot.smooth.line}},
\code{\link{stat.ma}}, \code{\link{lowess}}, \code{\link{plot}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}
mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Look at the normalized second data sets in the list using points to
## highlight large positive or large negative ratios.
plot.mva(mouse.data, mouse.setup, norm="l", 2, extra.type="pci",
plot.type="n") 

## Look at the both unnormalized and normalized first data sets in the
## list using text to highlight large positive or negative ratios.
## plot.mva(mouse.data, mouse.setup, norm="l", 2, extra.type="tci", plot.type="b") 
}     

%\keyword{microarray}

\keyword{hplot}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



