%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:34.
% Do NOT modify this file, instead modify the source (sma/R/Rinit.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{write.spot}

\alias{write.spot}

\title{Writing in Data Generated by the Image Analysis Package Spot}
\description{
  Function writes in a data file in a tab delimited table format.
  }

\usage{
write.spot(x, imageid, batch="output")
}

\arguments{
 \item{x}{the object to be written, typically a data frame. If not, it
   is attempted to create one from it.}
 \item{imageid}{integer value; the index of the slide which is
   considered}
 \item{batch}{character string, this refers to the name of a collection
   of experiments. The default batch name is "output".}
}
\details{
  This function writes the data in for each imageid, assigning each file
  the filename which takes the default form of "output".imageid.spot. The
  column names of x are written along with x in the table format
}

\references{ Spot manual \url{
  http://www.cmis.csiro.au/iap/Spot/spotmanual.htm}}  
  }

\author{ Jessica Mar }

\seealso{ \code{\link{write.table}, \code{\link{init.read.spot}} }

\examples{## Setting up the data
## library(Spot)
## SetParameters("mouse")
## Here is what you should see:
## Enter number of rows of grids per image (ngrid.r): 4
## Enter number of columns of grids per image (ngrid.c): 4
## Enter number of rows of spots per grid (nspot.r): 19
## Enter number of columns of spots per grid (nspot.c): 21
## Enter top/bottom translation tolerance, default is 50 (tolerance.r): 20
## Enter left/right translation, default is 50 (tolerance.c): 30
## Initialization complete

##Inputting Image Data 
## SetImages("mouse")
## Combining the red and green channels for the first slide
## mouse.array <- Spots("mouse", 1)

## Calling the function to write the data in
## write.spot(mouse.array, 1, "mouse")
}

\keyword{file}
%\keyword{microarray, Spot, Genepix.} 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
