% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statLearn.R
\name{logistErrorRate}
\alias{logistErrorRate}
\title{Calculate the Error Rate and Results Table for Logistic Regression Models}
\usage{
logistErrorRate(gmod, nw = NULL, p = 0.5)
}
\arguments{
\item{gmod}{A logistic regression model}

\item{nw}{A dataset for which a testing error rate should be calculated 
using the model in \code{gmod}. Note that it must contain the predictors as
well as the responses. If this argument is NULL (the default) the training
error rate will be calculated.}

\item{p}{Probability (default .5) above which the observation is assigned to
the second level of the response.}
}
\value{
List with training error rate if \code{nw} is NULL, testing error
rate otherwise, and a results table with responses versus predicted 
responses.
}
\description{
Calculate the testing error rate for a dataset on a logistic regression 
model (or the training error rate if no dataset is entered), and a results 
table with responses versus predicted responses.
}
\examples{
gmod=glm(state~.,binomial,Puromycin)
logistErrorRate(gmod)
}
