% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movres.R
\name{rMR}
\alias{rMR}
\alias{rMovRes}
\alias{rMRME}
\title{Sampling from a Moving-Resting Process with Embedded Brownian Motion}
\usage{
rMR(time, lamM, lamR, sigma, s0, dim = 2, state = FALSE)

rMovRes(time, lamM, lamR, sigma, s0, dim = 2)

rMRME(time, lamM, lamR, sigma, sig_err, s0, dim = 2, state = FALSE)
}
\arguments{
\item{time}{time points at which observations are to be simulated}

\item{lamM}{rate parameter of the exponential duration while moving}

\item{lamR}{rate parameter of the exponential duration while resting}

\item{sigma}{volatility parameter of the Brownian motion while moving}

\item{s0}{the state at time 0, must be one of "m" or "r", for moving and
resting, respectively}

\item{dim}{(integer) dimension of the Brownian motion}

\item{state}{indicates whether the simulation show the states at given
time points.}

\item{sig_err}{s.d. of Gaussian white noise}
}
\value{
A \code{data.frame} whose first column is the time points and whose
other columns are coordinates of the locations.
}
\description{
A moving-resting process consists of two states: moving and resting.
The transition between the two states is modeled by an alternating
renewal process, with exponentially distributed duration. An animal
stays at the same location while resting, and moves according to a
Brownian motion while moving.

'rMovRes' is deprecated. Using new function 'rMR' instead.

'rMRME' samples from moving-resting process with Guassian measurement error
}
\examples{
tgrid <- seq(0, 10, length=1001)
## make it irregularly spaced
tgrid <- sort(sample(tgrid, 800))
dat <- rMR(tgrid, 1, 1, 1, "m")
plot(dat[,1], dat[,2], xlab="t", ylab="X(t)", type='l')

dat2 <- rMR(tgrid, 1, 1, 1, "m", state = TRUE)
head(dat2)

dat3 <- rMRME(tgrid, 1, 1, 1, 0.01, "m", state = TRUE)
head(dat3)
plot(dat3[,1], dat3[,3], xlab="t", ylab="Z(t)=X(t)+GWN(0.01)", type="l")

}
\references{
Yan, J., Chen, Y., Lawrence-Apfel, K., Ortega, I. M., Pozdnyakov, V.,
Williams, S., and Meyer, T. (2014) A moving-resting process with an
embedded Brownian motion for animal movements.
Population Ecology. 56(2): 401--415.

Pozdnyakov, V., Elbroch, L., Labarga, A., Meyer, T., and Yan, J.
(2017) Discretely observed Brownian motion governed by telegraph
process: estimation. Methodology and Computing in Applied Probability.
doi:10.1007/s11009-017-9547-6.
}
