% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.sumiv}
\alias{smbinning.sumiv}
\title{Information Value Summary}
\usage{
smbinning.sumiv(df, y)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot. Name "default" is not allowed.}
}
\value{
The command \code{smbinning.sumiv} generates a table that lists each characteristic 
with its corresponding IV for those where the calculation is possible, otherwise it will generate a 
missing value (\code{NA}).
}
\description{
It gives the user the ability to calculate, in one step, the IV for each characteristic of the dataset.
This function also shows a progress bar so the user can see the status of the process.
}
\examples{
# Load library and its dataset
library(smbinning)

# Test sample
test=subset(smbsimdf1,rnd>0.9) # Training sample
test$rnd=NULL

# Example: Information Value Summary
testiv=smbinning.sumiv(test,y="fgood")
testiv

# Example: Plot of Information Value Summary
smbinning.sumiv.plot(testiv)
}
