% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nndist.R
\name{nndist}
\alias{nndist}
\title{Determine nearest neighbors based on maximum distance}
\usage{
nndist(d, ubd)
}
\arguments{
\item{d}{An \eqn{n\times n} square distance matrix
containing the intercentroid distance between the
\eqn{n} region centroids.}

\item{ubd}{A proportion in (0, 1].  The distance of
potential clusters must be no more than \code{ubd * m}, 
where \code{m} is the maximum intercentroid distance
between all coordinates.}
}
\value{
Returns the indices of the nearest neighbors as a
  list.
}
\description{
\code{nndist} determines the nearest
neighbors for a set of observations within a certain
radius.
}
\details{
This function determines the nearest neighbors of each
centroid based on the intercentroid distance.  The number
of nearest neighbors is limited by the furthest distance
between the starting centroid and the farthest neighbor.
}
\examples{
data(nydf)
coords = as.matrix(nydf[,c("longitude", "latitude")])
d = as.matrix(dist(coords))
nn = nndist(d, ubd = 0.01)
}
\author{
Joshua French
}
