% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noz.R
\name{noz}
\alias{noz}
\title{Determine non-overlapping zones}
\usage{
noz(x)
}
\arguments{
\item{x}{A list containing the candidate zones.}
}
\value{
A vector with the list indices of the 
  non-overlapping zones.
}
\description{
Determine non-overlapping zones from a list of
candidate zones.
}
\details{
The function takes a list of candidate zones. Each
element of the list contains a candidate zones. The
candidate zones are defined by the location indices of
the regions comprising the zones.  Starting with the
first candidate zone, the function excludes every
candidate zone that intersects the first (any other
candidate zone that shares indices with the first zone).
Moving onto the next non-overlapping candidate zone,
the process is repeated. 
The function returns the indices (in the list of
zones) of the zones that do not overlap.
}
\examples{
x = list(1:2, 1:3, 4:5, 4:6, 7:8)
noz(x)
}
\author{
Joshua French
}
