% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{aux_gw}
\alias{aux_gw}
\title{Mean of a Generalized Wendland covariance function (Internal use)}
\usage{
aux_gw(dist, sigsq, phi, kappa, mu)
}
\arguments{
\item{sigsq}{the \eqn{\sigma^2} variance of the covariance function
function.}

\item{phi}{the \eqn{\phi} is the range parameter of the covariance function.}

\item{kappa}{\eqn{\kappa \in \{0, \ldots, 3 \}}.}

\item{mu}{\eqn{\mu} controls the smoothness of the covariance function}

\item{dists}{a numeric matrix representing the distance between spatial
entities.}
}
\value{
The mean of \code{mat_cov(dist, sigsq, phi, kappa)}.
}
\description{
This is an auxilliary function for internal use. It helps to
numerically integrate a covariance function evaluated at a grid of points
within a polyigon and speed-up the computations.
}
\keyword{internal}
