% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pexp_cov}
\alias{pexp_cov}
\title{Powered Exponential covariance function for a given distance matrix.}
\usage{
pexp_cov(dists, sigsq, phi, nu)
}
\arguments{
\item{dists}{a numeric matrix representing the distance between spatial
entities.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Exponential covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Exponential covariance function,
controls the range of the spatial dependence.}

\item{nu}{the \eqn{\nu \in (0, 2]} parameter representing the "power"}
}
\value{
The powered exponential covariance function (for a stationary and
isotropic process) associated with the provided distances (\code{dists})
and the given set of parameters.
}
\description{
Computing the Matern covariance function for a matrix of
distances.
}
\seealso{
\code{\link{single_exp}}, \code{\link{single_matern}}
}
\keyword{internal}
