% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ShepFun1}
\alias{ShepFun1}
\alias{ShepFun2}
\alias{ShepFun3}
\alias{ShepFun4}
\alias{ShepFun5}
\alias{ShepFuns}
\title{Test functions for/from SHEPPACK}
\usage{
ShepFun1(x)
}
\arguments{
\item{x}{A numeric vector with arbitrary length.}
}
\value{
Function's value.
}
\description{
Test functions for/from SHEPPACK
}
\details{
These functions are described in the article cited in the \bold{references}
section.
\deqn{f_1(\mathbf{x}) = 1 + \frac{2}{d} \, \left| d/2 - \sum_i x_i
\right|}{ f1(x) = 1 + (2/d) | (d/2) - sum_i x_i |}
\deqn{f_2(\mathbf{x}) = 1 - \frac{2}{d}\, \sum_i \left|x_i - 0.5
\right|}{ f2(x) = 1 - (2/d) sum_i |x_i - 0.5 |}
\deqn{f_3(\mathbf{x}) = 1 - 2 \, \max_{i} \left|x_i - 0.5 \right|}{
f3(x) = 1 - 2 max_{i} |x_i - 0.5 |}
\deqn{f_4(\mathbf{x}) = \prod_i \left[ 1 - 2 \left| x_i - 0.5
\right| \right]}{ f4(x) = prod_i [ 1 - 2 | x_i - 0.5 | ]}
\deqn{f_5(\mathbf{x}) = 1 - c_5 \, \left[ \sum_i \left|x_i - 0.5
\right| + \prod_i \left| x_i - 0.5 \right| \right]}{ f5(x) = 1 -
c_5 [ sum_i |x_i - 0.5 | + prod_i | x_i - 0.5 | ]}
where \eqn{c_5 = d/2 + (0.5)^d}, and all sums or products are for
\eqn{i=1} to \eqn{d}. All these functions are defined on
\eqn{[0,\,1]^d} and take values in \eqn{[0,1]}. The four functions
\eqn{f_i} for \eqn{i > 1} have an unique maximum located at
\eqn{\mathbf{x}^\star}{xStar} with all coordinates \eqn{x_j^\star
= 0.5}{xStar[j] = 0.5} and \eqn{f_i(\mathbf{x}^\star) =1}{f_i(xStar) = 1}.
}
\note{
These functions are also exported as elements of the
\code{ShepFuns} list.
}
\examples{
## interpolate 'Shepfun3' for d = 4
d <- 4
GDd <- Grid(nlevels = rep(8, d))
fGrid <- apply_Grid(GDd, ShepFun3)
Xoutd <- matrix(runif(200 * d), ncol = d)
GI <- interp_Grid(X = GDd, Y = fGrid, Xout = Xoutd)
F <- apply(Xoutd, 1, ShepFun3)
max(abs(F - GI))

## 3D plot
require(lattice)
X <- as.data.frame(Grid(nlevels = c("x1" = 30, "x2" = 30)))
df <- data.frame(x1 = numeric(0), x2 = numeric(0),
                 f = numeric(0), i = numeric(0))
for (i in 1:5) {
   f <- apply(X, 1, ShepFuns[[i]])
   df <- rbind(df, data.frame(x1 = X$x1, x2 = X$x2, f = f, i = i))
}
pl <- wireframe(f ~ x1 * x2 | i, data = df,
                outer = TRUE, shade = FALSE, zlab = "",
                screen = list(z = 20, x = -30),
                strip = strip.custom(strip.names = c(TRUE),
                                     strip.levels = c(TRUE)),
                main = "", horizontal = TRUE, col = "SpringGreen4")
pl
}
\references{
W.I. Thacker, J. Zhang, L.T. Watson, J.B. Birch,
M.A. Iyer and M.W. Berry (2010). Algorithm 905: SHEPPACK: Modified
Shepard Algorithm for Interpolation of Scattered Multivariate Data
\emph{ACM Trans. on Math. Software} (TOMS) Vol. 37, n. 3.
\href{http://dl.acm.org/citation.cfm?id=1824812}{link}
}

