% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mof.WFG6.R
\name{makeWFG6Function}
\alias{makeWFG6Function}
\title{WFG6 Function}
\usage{
makeWFG6Function(n.objectives, k, l)
}
\arguments{
\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives.}

\item{k}{[\code{integer}(1)]\cr
Number of position-related parameters. These will automatically be the
first \code{k} elements from the input vector. This value has to be a
multiple of \code{n.objectives - 1}.}

\item{l}{[\code{integer}(1)]\cr
Number of distance-related parameters. These will automatically be
the last \code{l} elements from the input vector.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Sixth test problem from the "Walking Fish Group" problem generator toolkit.
}
\details{
Huband et al. recommend a value of \code{k = 4L} position-related
  parameters for bi-objective problems and \code{k = 2L * (n.objectives - 1L)}
  for many-objective problems. Furthermore the authors recommend a value of
  \code{l = 20} distance-related parameters. Therefore, if \code{k} and/or
  \code{l} are not explicitly defined by the user, their values will be set
  to the recommended values per default.
}
\references{
S. Huband, P. Hingston, L. Barone, and L. While, "A Review of Multi-objective
Test Problems and a Scalable Test Problem Toolkit," in IEEE Transactions on
Evolutionary Computation, Volume 10, No 5, October 2006, pp. 477-506. IEEE.
}
