% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnof.R
\name{mnof}
\alias{mnof}
\title{Helper function to create numeric multi-objective optimization test function.}
\usage{
mnof(name = NULL, id = NULL, par.len = NULL, par.id = "x",
  par.lower = NULL, par.upper = NULL, n.objectives,
  description = NULL, fn, vectorized = FALSE, noisy = FALSE,
  fn.mean = NULL, minimize = rep(TRUE, n.objectives),
  constraint.fn = NULL, ref.point = NULL)
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Function name. Used for the title of plots for example.}

\item{id}{[\code{character(1)} | \code{NULL}]\cr
Optional short function identifier. If provided, this should be a short
name without whitespaces and now special characters beside the underscore.
Default is \code{NULL}, which means no ID at all.}

\item{par.len}{[\code{integer(1)}]\cr
Length of parameter vector.}

\item{par.id}{[\code{character(1)}]\cr
Optional name of parameter vector.
Default is \dQuote{x}.}

\item{par.lower}{[\code{numeric}]\cr
Vector of lower bounds. A single value of length 1 is automatically replicated
to \code{n.pars}.
Default is -Inf.}

\item{par.upper}{[\code{numeric}]\cr
Vector of upper bounds. A singe value of length 1 is automatically replicated
to \code{n.pars}.
Default is Inf.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives of the multi-objective function.}

\item{description}{[\code{character(1)} | \code{NULL}]\cr
Optional function description.}

\item{fn}{[\code{function}]\cr
Objective function.}

\item{vectorized}{[\code{logical(1)}]\cr
Can the objective function handle \dQuote{vector} input, i.~e., does it
accept matrix of parameters? Default is \code{FALSE}.}

\item{noisy}{[\code{logical(1)}]\cr
Is the function noisy? Defaults to \code{FALSE}.}

\item{fn.mean}{[\code{function}]\cr
Optional true mean function in case of a noisy objective function. This functions should
have the same mean as \code{fn}.}

\item{minimize}{[\code{logical}]\cr
Logical vector of length \code{n.objectives} indicating if the corresponding
objectives shall be minimized or maximized.
Default is the vector with all components set to \code{TRUE}.}

\item{constraint.fn}{[\code{function | NULL}]\cr
Function which returns a logical vector indicating whether certain conditions
are met or not. Default is \code{NULL}, which means, that there are no constraints
beside possible box constraints defined via the \code{par.set} argument.}

\item{ref.point}{[\code{numeric}]\cr
Optional reference point in the objective space, e.g., for hypervolume computation.}
}
\description{
This is a simplifying wrapper around \code{\link{makeMultiObjectiveFunction}}.
It can be used if the function to generate is purely numeric to save some lines
of code.
}
\examples{
# first we generate the 10d sphere function the long way
fn = makeMultiObjectiveFunction(
  name = "Testfun",
  fn = function(x) c(sum(x^2), exp(sum(x^2))),
  par.set = makeNumericParamSet(
    len = 10L, id = "a",
    lower = rep(-1.5, 10L), upper = rep(1.5, 10L)
  ),
  n.objectives = 2L
)

# ... and now the short way
fn = mnof(
 name = "Testfun",
 fn = function(x) c(sum(x^2), exp(sum(x^2))),
 par.len = 10L, par.id = "a", par.lower = -1.5, par.upper = 1.5,
 n.objectives = 2L
)
}
