% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{forecast.smooth}
\alias{forecast.smooth}
\alias{forecast}
\title{Forecasting time series using smooth functions}
\usage{
\method{forecast}{smooth}(object, h = 10, intervals = c("parametric",
  "semiparametric", "nonparametric", "none"), level = 0.95, ...)
}
\arguments{
\item{object}{Time series model for which forecasts are required.}

\item{h}{Forecast horizon}

\item{intervals}{Type of intervals to construct. See \link[smooth]{es} for
details.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{...}{Other arguments accepted by either \link[smooth]{es},
\link[smooth]{ces}, \link[smooth]{ges} or \link[smooth]{ssarima}.}
}
\value{
Returns object of class "smooth.forecast", which contains:

\itemize{
\item \code{model} - the estimated model (ES / CES / GES / SSARIMA).
\item \code{method} - the name of the estimated model (ES / CES / GES / SSARIMA).
\item \code{fitted} - fitted values of the model.
\item \code{actuals} - actuals provided in the call of the model.
\item \code{forecast} aka \code{mean} - point forecasts of the model
(conditional mean).
\item \code{lower} - lower bound of prediction intervals.
\item \code{upper} - upper bound of prediction intervals.
\item \code{level} - confidence level.
\item \code{intervals} - binary variable (whether intervals were produced or not).
\item \code{residuals} - the residuals of the original model.
}
}
\description{
This function is created in order for the package to be compatible with Rob
Hyndman's "forecast" package
}
\details{
This is not a compulsary function. You can simply use \link[smooth]{es},
\link[smooth]{ces}, \link[smooth]{ges} or \link[smooth]{ssarima} without
\code{forecast.smooth}. But if you are really used to \code{forecast}
function, then go ahead!
}
\examples{

ourModel <- ces(rnorm(100,0,1),h=10)

forecast.smooth(ourModel,h=10)
forecast.smooth(ourModel,h=10,intervals=TRUE)
plot(forecast.smooth(ourModel,h=10,intervals=TRUE))

}
\references{
Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://www.exponentialsmoothing.net}.
}
\seealso{
\code{\link[forecast]{ets}, \link[forecast]{forecast}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{forecast}
