% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-measures.R
\name{MAE}
\alias{MAE}
\alias{Errors}
\alias{MSE}
\alias{MRE}
\alias{MPE}
\alias{MAPE}
\alias{SMAPE}
\alias{MASE}
\alias{RelMAE}
\alias{RelMSE}
\alias{RelAME}
\alias{sMSE}
\alias{sPIS}
\alias{sCE}
\title{Error measures}
\usage{
MAE(actual, forecast, digits = 3)

MSE(actual, forecast, digits = 3)

MRE(actual, forecast, digits = 3)

MPE(actual, forecast, digits = 3)

MAPE(actual, forecast, digits = 3)

SMAPE(actual, forecast, digits = 3)

MASE(actual, forecast, scale, digits = 3)

RelMAE(actual, forecast, benchmark, digits = 3)

RelMSE(actual, forecast, benchmark, digits = 3)

RelAME(actual, forecast, benchmark, digits = 3)

sMSE(actual, forecast, scale, digits = 3)

sPIS(actual, forecast, scale, digits = 3)

sCE(actual, forecast, scale, digits = 3)
}
\arguments{
\item{actual}{The vector or matrix of actual values.}

\item{forecast}{The vector or matrix of forecasts values.}

\item{digits}{Number of digits of the output.}

\item{scale}{The value that should be used in the denominator of MASE. Can
be anything but advised values are: mean absolute deviation of in-sample one
step ahead Naive error or mean absolute value of the in-sample actuals.}

\item{benchmark}{The vector or matrix of the forecasts of the benchmark
model.}
}
\value{
All the functions return the scalar value.
}
\description{
Functions allow to calculate different types of errors:
\enumerate{
\item MAE - Mean Absolute Error,
\item MSE - Mean Squared Error,
\item MRE - Mean Root Error,
\item MPE - Mean Percentage Error,
\item MAPE - Mean Absolute Percentage Error,
\item SMAPE - Symmetric Mean Absolute Percentage Error,
\item MASE - Mean Absolute Scaled Error,
\item RelMAE - Relative Mean Absolute Error,
\item RelMSE - Relative Mean Squared Error,
\item RelAME - Relative Absolute Mean Error,
\item sMSE - Scaled Mean Squared Error,
\item sPIS- Scaled Periods-In-Stock,
\item sCE - Scaled Cumulative Error.
}
}
\details{
In case of \code{sMSE}, \code{scale} needs to be a squared value. Typical
one -- squared mean value of in-sample actuals.

SMAPE is biased and prefers when you overforecast, so be careful when
using it.
}
\examples{


y <- rnorm(100,10,2)
esmodel <- es(y[1:90],model="ANN",h=10)

MAE(y[91:100],esmodel$forecast,digits=5)
MSE(y[91:100],esmodel$forecast,digits=5)

MPE(y[91:100],esmodel$forecast,digits=5)
MAPE(y[91:100],esmodel$forecast,digits=5)
MASE(y[91:100],esmodel$forecast,mean(abs(y[1:90])),digits=5)
MASE(y[91:100],esmodel$forecast,mean(abs(diff(y[1:90]))),digits=5)

esmodel2 <- es(y[1:90],model="AAN",h=10)
RelMAE(y[91:100],esmodel2$forecast,esmodel$forecast,digits=5)

MASE(y[91:100],esmodel$forecast,mean(abs(y[1:90]))^2,digits=5)

sMSE(y[91:100],esmodel$forecast,mean(abs(y[1:90])),digits=5)
sPIS(y[91:100],esmodel$forecast,mean(abs(y[1:90])),digits=5)
sCE(y[91:100],esmodel$forecast,mean(abs(y[1:90])),digits=5)

}
\references{
\itemize{
\item Svetunkov, I. (2017). Naughty APEs and the quest for the holy grail.
\url{https://forecasting.svetunkov.ru/en/2017/07/29/naughty-apes-and-the-quest-for-the-holy-grail/}
\item Fildes R. (1992). The evaluation of
extrapolative forecasting methods. International Journal of Forecasting, 8,
pp.81-98.
\item Hyndman R.J., Koehler A.B. (2006). Another look at measures of
forecast accuracy. International Journal of Forecasting, 22, pp.679-688.
\item Petropoulos F., Kourentzes N. (2015). Forecast combinations for
intermittent demand. Journal of the Operational Research Society, 66,
pp.914-924.
\item Wallstrom P., Segerstedt A. (2010). Evaluation of forecasting error
measurements and techniques for intermittent demand. International Journal
of Production Economics, 128, pp.625-636.
\item Davydenko, A., Fildes, R. (2013). Measuring Forecasting Accuracy:
The Case Of Judgmental Adjustments To Sku-Level Demand Forecasts.
International Journal of Forecasting, 29(3), 510-522.
\url{https://doi.org/10.1016/j.ijforecast.2012.09.002}
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
