% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam.R
\name{rmultistep}
\alias{rmultistep}
\title{Multiple steps ahead forecast errors}
\usage{
rmultistep(object, h = 10, ...)
}
\arguments{
\item{object}{Model estimated using one of the forecasting functions.}

\item{h}{The forecasting horizon to use.}

\item{...}{Currently nothing is accepted via ellipsis.}
}
\value{
The matrix with observations in rows and h steps ahead values in columns.
So, the first row corresponds to the forecast produced from the 0th observation
from 1 to h steps ahead.
}
\description{
The function extracts 1 to h steps ahead forecast errors from the model.
}
\details{
The errors correspond to the error term epsilon_t in the ETS models. Don't forget
that different models make different assumptions about epsilon_t and / or 1+epsilon_t.
}
\examples{

x <- rnorm(100,0,1)
ourModel <- adam(x)
rmultistep(ourModel, h=13)

}
\seealso{
\link[stats]{residuals},
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
