% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{graphicalLasso}
\alias{graphicalLasso}
\title{Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the graphical Lasso.}
\usage{
graphicalLasso(S, lambda)
}
\arguments{
\item{S}{The sample covariance matrix.}

\item{lambda}{The regularization parameter of the graphical Lasso.}
}
\value{
A list with three functions, precisely the objective \eqn{u}, penalty \eqn{v}, and dependence structure \eqn{w}. Not all derivatives are available in closed form, and thus computing the numerical derivative of the entire objective function is recommended.
}
\description{
Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the graphical Lasso.
}
\examples{
library(smoothedLasso)
p <- 30
S <- matrix(rWishart(1,p,diag(p)),p)
lambda <- 1
temp <- graphicalLasso(S,lambda)

}
\references{
Friedman, J., Hastie, T., and Tibshirani, R. (2008). Sparse inverse covariance estimation with the graphical lasso. Biostatistics, 9(3):432-441.

Friedman, J., Hastie, T., and Tibshirani, R. (2019). glasso: Graphical Lasso: Estimation of Gaussian Graphical Models. R package version 1.11.

Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
