\name{plotTries}
\alias{plotTries}
\title{Plot selection results}
\usage{
plotTries(insms, number)
}
\arguments{
  \item{insms}{The input results}

  \item{number}{the number of the area to plot}
}
\description{
Plot the selection process of an area from a
microsimulation object.
}
\details{
Plot errors during selection process for an area.
}
\examples{
library(sms)
data(survey) #load the data
data(census)
in.lexicon=createLexicon() # Create a data lexicon for holding the associated column names.
in.lexicon=addDataAssociation(in.lexicon, c("he","he"))
in.lexicon=addDataAssociation(in.lexicon, c("females","female"))

ansms = new("microsimulation", census=census, panel=survey, lexicon=in.lexicon, iterations=5)
sa = run_parallel_SA(ansms)
plotTries( sa, 1 )
}
\author{
Dimitris Kavroudakis \email{dimitris123@gmail.com}
}

