\name{dst}
\alias{dst}
\alias{pst}
\alias{rst}
\title{
Skew-t Distribution
}
\description{
Density function, distribution function and random number
generation for the skew-t (ST) distribution.
}
\usage{
dst(x, location=0, scale=1, shape=0, df=Inf)
pst(x, location=0, scale=1, shape=0, df=Inf, ...)
rst(n=1, location=0, scale=1, shape=0, df=Inf)
}
\arguments{
\item{x}{
vector of quantiles. Missing values (\code{NA}s) are allowed.
}
\item{location}{
vector of location parameters.
}
\item{scale}{
vector of (positive) scale parameters.
}
\item{shape}{
vector of shape parameters. With \code{pst}, it must be of
length 1.
}
\item{df}{
degrees of freedom (scalar); default is \code{df=Inf} which corresponds 
to the skew-normal distribution.
}
\item{n}{
sample size.
}
\item{...}{
additional parameters passed to \code{pmvt}.
}}
\value{
Density (\code{dst}), probability (\code{pst}) and random sample (\code{rst})
from the skew-t distribution with given \code{location}, \code{scale},
\code{shape} and \code{df} parameters.
}
\section{Background}{
The family of skew-t distributions is an extension of the Student's t
family, via the introduction of a \code{shape} parameter which regulates
skewness; when \code{shape=0}, the skew-t distribution reduces to the
usual t distribution. When \code{df=Inf}, it reduces to the skew-normal
distribution. A multivariate version of the distribution exists.
See the reference below for additional information.
}
\details{
\code{pst} requires \code{library(mvtnorm)}.
}
\references{
Azzalini, A. and Capitanio, A. (2002).
  Distributions generated by perturbation of symmetry 
  with emphasis on a multivariate skew \emph{t} distribution.
  Submitted to \emph{J.Roy. Statist. Soc.}
}
\seealso{
\code{\link{dmst}}, \code{\link{dsn}}, \code{\link{mst.mle}}
}
\examples{
pdf <- dst(seq(-4,4,by=0.1), shape=3, df=5)
rnd <- rst(100, 5, 2, -5, 8)
library(mvtnorm)              # only once in the session
cdf <- pst(seq(-4,4,by=0.1), shape=3, df=5)

}
\keyword{distribution}
