\name{st.cumulants}
\alias{st.cumulants}
\title{
Cumulants of the skew-t distribution
}
\description{
Cumulants of the skew-t distribution.
}
\usage{
st.cumulants(shape=0, df=Inf, n=4)
}
\arguments{
\item{shape}{
shape parameter (scalar).
}
\item{df}{
degrees of freedom (scalar); default is \code{df=Inf} which corresponds 
to the skew-normal distribution.
}
\item{n}{
a scalar integer, from 1 to 4.
}}
\value{
the cumulants up to order \code{n} of the skew-t distribution
with the selected parameters.
}
\details{
Expressions of the moments and other details on the skew-t distribution are 
given in the refence below.
}
\references{
Azzalini, A. and Capitanio, A. (2003).
Distributions generated by perturbation of symmetry 
with emphasis on a multivariate skew-\emph{t} distribution.
\emph{J.Roy. Statist. Soc. B} 
\bold{65}, 367--389.
}
\seealso{
\code{\link{sn.cumulants}},\code{\link{dst}}
}
\examples{
cum <- st.cumulants(shape=3, df=5)
}
\keyword{distribution}

